/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.jms.runtime.EventStreamListener;
import org.fabric3.binding.jms.runtime.ListenerMonitor;
import org.fabric3.binding.jms.runtime.host.JmsHost;
import org.fabric3.binding.jms.runtime.host.ListenerConfiguration;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionSourceAttacher
implements SourceConnectionAttacher<JmsConnectionSourceDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;
    private JmsHost jmsHost;
    private ListenerMonitor monitor;

    public JmsConnectionSourceAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference JmsHost jmsHost, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
        this.jmsHost = jmsHost;
        this.monitor = monitor;
    }

    public void attach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI serviceUri = target.getTargetUri();
        ClassLoader sourceClassLoader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        ResolvedObjects objects = this.resolveAdministeredObjects(source);
        ListenerConfiguration configuration = new ListenerConfiguration();
        try {
            ConnectionFactory connectionFactory = objects.getRequestFactory();
            Destination destination = objects.getRequestDestination();
            List streams = connection.getEventStreams();
            if (streams.size() != 1) {
                throw new ConnectionAttachException("There must be a single event stream:" + streams.size());
            }
            EventStream stream = (EventStream)streams.get(0);
            EventStreamListener listener = new EventStreamListener(sourceClassLoader, stream.getHeadHandler(), this.monitor);
            configuration.setDestination(destination);
            configuration.setFactory(connectionFactory);
            configuration.setMessageListener(listener);
            configuration.setUri(serviceUri);
            configuration.setType(TransactionType.NONE);
            this.populateConfiguration(configuration, source.getMetadata());
            if (this.jmsHost.isRegistered(serviceUri)) {
                this.jmsHost.unregister(serviceUri);
            }
            this.jmsHost.register(configuration);
        }
        catch (JMSException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
    }

    public void detach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ConnectionAttachException {
    }

    private void populateConfiguration(ListenerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.SESSION == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        configuration.setTransactionTimeout(metadata.getTransactionTimeout());
    }

    private ResolvedObjects resolveAdministeredObjects(JmsConnectionSourceDefinition source) throws ConnectionAttachException {
        try {
            JmsBindingMetadata metadata = source.getMetadata();
            Hashtable<String, String> env = metadata.getEnv();
            ConnectionFactoryDefinition requestConnectionFactoryDefinition = metadata.getConnectionFactory();
            requestConnectionFactoryDefinition.setName("default");
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(requestConnectionFactoryDefinition, env);
            DestinationDefinition requestDestinationDefinition = metadata.getDestination();
            Destination requestDestination = this.resolver.resolve(requestDestinationDefinition, requestConnectionFactory, env);
            ConnectionFactory responseConnectionFactory = null;
            Destination responseDestination = null;
            return new ResolvedObjects(requestConnectionFactory, requestDestination, responseConnectionFactory, responseDestination);
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private ConnectionFactory responseFactory;
        private Destination requestDestination;
        private Destination responseDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, Destination requestDestination, ConnectionFactory responseFactory, Destination responseDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
            this.responseFactory = responseFactory;
            this.responseDestination = responseDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public ConnectionFactory getResponseFactory() {
            return this.responseFactory;
        }

        public Destination getRequestDestination() {
            return this.requestDestination;
        }

        public Destination getResponseDestination() {
            return this.responseDestination;
        }
    }
}

