/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fabric3.binding.jms.runtime.JmsEventStreamHandler;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionTargetAttacher
implements TargetConnectionAttacher<JmsConnectionTargetDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;

    public JmsConnectionTargetAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        Destination destination;
        ConnectionFactory connectionFactory;
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        JmsBindingMetadata metadata = target.getMetadata();
        Hashtable<String, String> env = metadata.getEnv();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        connectionFactoryDefinition.setName("default");
        try {
            connectionFactory = this.resolver.resolve(connectionFactoryDefinition, env);
            DestinationDefinition destinationDefinition = metadata.getDestination();
            destination = this.resolver.resolve(destinationDefinition, connectionFactory, env);
        }
        catch (JmsResolutionException e) {
            throw new ConnectionAttachException((Throwable)((Object)e));
        }
        for (EventStream stream : connection.getEventStreams()) {
            JmsEventStreamHandler handler = new JmsEventStreamHandler(destination, connectionFactory, classLoader);
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    public void detach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target) throws ConnectionAttachException {
    }
}

