/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.spi.channel.EventStreamHandler;
import org.oasisopen.sca.ServiceRuntimeException;

public class JmsEventStreamHandler
implements EventStreamHandler {
    private Destination destination;
    private ConnectionFactory connectionFactory;
    private ClassLoader classLoader;

    public JmsEventStreamHandler(Destination destination, ConnectionFactory connectionFactory, ClassLoader classLoader) {
        this.destination = destination;
        this.connectionFactory = connectionFactory;
        this.classLoader = classLoader;
    }

    public void handle(Object event) {
        if (!(event instanceof Serializable)) {
            throw new ServiceRuntimeException("Event type must be serializable: " + event.getClass().getName());
        }
        Serializable payload = (Serializable)event;
        Connection connection = null;
        Session session = null;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            connection = this.connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            ObjectMessage jmsMessage = session.createObjectMessage(payload);
            producer.send((Message)jmsMessage);
        }
        catch (JMSException ex) {
            try {
                throw new ServiceRuntimeException("Unable to receive response", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    public void setNext(EventStreamHandler next) {
        throw new IllegalStateException("This handler must be the last one in the handler sequence");
    }

    public EventStreamHandler getNext() {
        return null;
    }
}

