/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.binding.jms.runtime.InterceptorConfiguration;
import org.fabric3.binding.jms.runtime.ResponseListener;
import org.fabric3.binding.jms.runtime.WireConfiguration;
import org.fabric3.binding.jms.runtime.common.JmsBadMessageException;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.common.MessageHelper;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.util.Base64;
import org.fabric3.spi.wire.Interceptor;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class JmsInterceptor
implements Interceptor {
    private static final Message ONE_WAY_RESPONSE = new MessageImpl();
    private Interceptor next;
    private String methodName;
    private OperationPayloadTypes payloadTypes;
    private Destination destination;
    private ConnectionFactory connectionFactory;
    private CorrelationScheme correlationScheme;
    private ResponseListener responseListener;
    private ClassLoader cl;
    private boolean oneWay;
    private TransactionType transactionType;
    private TransactionManager tm;
    private long responseTimeout;

    public JmsInterceptor(InterceptorConfiguration configuration) {
        WireConfiguration wireConfig = configuration.getWireConfiguration();
        this.destination = wireConfig.getRequestDestination();
        this.connectionFactory = wireConfig.getRequestConnectionFactory();
        this.correlationScheme = wireConfig.getCorrelationScheme();
        this.cl = wireConfig.getClassloader();
        this.responseListener = wireConfig.getResponseListener();
        this.tm = wireConfig.getTransactionManager();
        this.transactionType = wireConfig.getTransactionType();
        this.responseTimeout = wireConfig.getResponseTimeout();
        this.oneWay = configuration.isOneWay();
        this.methodName = configuration.getOperationName();
        this.payloadTypes = configuration.getPayloadTypes();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message invoke(Message message) {
        Message message2;
        boolean begun;
        Transaction suspended;
        ClassLoader oldCl;
        Session session;
        Connection connection;
        block23: {
            connection = null;
            session = null;
            oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.cl);
            connection = this.connectionFactory.createConnection();
            connection.start();
            int status = this.tm.getStatus();
            suspended = null;
            begun = false;
            if (6 == status && TransactionType.GLOBAL == this.transactionType) {
                this.tm.begin();
                begun = true;
            } else if (0 == status && TransactionType.NONE == this.transactionType) {
                suspended = this.tm.suspend();
            }
            session = TransactionType.GLOBAL == this.transactionType ? connection.createSession(true, 0) : connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            javax.jms.Message jmsMessage = this.createMessage(message, session);
            producer.send(jmsMessage);
            String correlationId = null;
            switch (this.correlationScheme) {
                case NONE: 
                case CORRELATION_ID: {
                    throw new UnsupportedOperationException("Correlation scheme not supported");
                }
                case MESSAGE_ID: {
                    correlationId = jmsMessage.getJMSMessageID();
                    break;
                }
            }
            if (this.oneWay) break block23;
            Message resp = this.receive(correlationId, session);
            if (begun) {
                this.tm.commit();
            }
            if (suspended != null) {
                this.tm.resume(suspended);
            }
            Message message3 = resp;
            JmsHelper.closeQuietly(session);
            JmsHelper.closeQuietly(connection);
            Thread.currentThread().setContextClassLoader(oldCl);
            return message3;
        }
        try {
            if (begun) {
                this.tm.commit();
            }
            if (suspended != null) {
                this.tm.resume(suspended);
            }
            message2 = ONE_WAY_RESPONSE;
        }
        catch (JMSException ex) {
            try {
                throw new ServiceRuntimeException("Unable to receive response", (Throwable)ex);
                catch (IOException ex2) {
                    throw new ServiceRuntimeException("Error serializing callframe", (Throwable)ex2);
                }
                catch (JmsBadMessageException ex3) {
                    throw new ServiceRuntimeException("Unable to receive response", (Throwable)((Object)ex3));
                }
                catch (SystemException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
                catch (NotSupportedException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
                catch (HeuristicMixedException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
                catch (HeuristicRollbackException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
                catch (RollbackException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeQuietly(session);
                JmsHelper.closeQuietly(connection);
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }
        JmsHelper.closeQuietly(session);
        JmsHelper.closeQuietly(connection);
        Thread.currentThread().setContextClassLoader(oldCl);
        return message2;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    private Message receive(String correlationId, Session session) throws JMSException, JmsBadMessageException {
        javax.jms.Message resultMessage = this.responseListener.receive(correlationId, session, this.responseTimeout);
        if (resultMessage == null) {
            throw new ServiceUnavailableException("Timeout waiting for response to message: " + correlationId);
        }
        MessageImpl response = new MessageImpl();
        if (resultMessage.getBooleanProperty("f3Fault")) {
            Object payload = MessageHelper.getPayload(resultMessage, this.payloadTypes.getFaultType());
            response.setBodyWithFault(payload);
        } else {
            Object payload = MessageHelper.getPayload(resultMessage, this.payloadTypes.getOutputType());
            response.setBody(payload);
        }
        return response;
    }

    private javax.jms.Message createMessage(Message message, Session session) throws JMSException, IOException {
        Object[] payload = (Object[])message.getBody();
        switch (this.payloadTypes.getInputType()) {
            case OBJECT: {
                ObjectMessage jmsMessage = session.createObjectMessage((Serializable)payload);
                this.setRoutingHeaders(message, (javax.jms.Message)jmsMessage);
                return jmsMessage;
            }
            case STREAM: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            case XML: 
            case TEXT: {
                if (payload.length != 1) {
                    throw new UnsupportedOperationException("Only single parameter operations are supported");
                }
                TextMessage jmsMessage = session.createTextMessage((String)payload[0]);
                this.setRoutingHeaders(message, (javax.jms.Message)jmsMessage);
                return jmsMessage;
            }
        }
        if (payload.length != 1) {
            throw new AssertionError((Object)"Bytes messages must have a single parameter");
        }
        javax.jms.Message jmsMessage = MessageHelper.createBytesMessage(session, payload[0], this.payloadTypes.getInputType());
        this.setRoutingHeaders(message, jmsMessage);
        return jmsMessage;
    }

    private void setRoutingHeaders(Message message, javax.jms.Message jmsMessage) throws JMSException, IOException {
        jmsMessage.setObjectProperty("scaOperationName", (Object)this.methodName);
        List stack = message.getWorkContext().getCallFrameStack();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(bas);
        stream.writeObject(stack);
        stream.close();
        String encoded = Base64.encode((byte[])bas.toByteArray());
        jmsMessage.setStringProperty("f3Context", encoded);
    }
}

