/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.jms.runtime.InvocationChainHolder;
import org.fabric3.binding.jms.runtime.ListenerMonitor;
import org.fabric3.binding.jms.runtime.ServiceListener;
import org.fabric3.binding.jms.runtime.WireHolder;
import org.fabric3.binding.jms.runtime.host.JmsHost;
import org.fabric3.binding.jms.runtime.host.ListenerConfiguration;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.provision.JmsSourceDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSourceWireAttacher
implements SourceWireAttacher<JmsSourceDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;
    private JmsHost jmsHost;
    private ListenerMonitor monitor;

    public JmsSourceWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference JmsHost jmsHost, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
        this.jmsHost = jmsHost;
        this.monitor = monitor;
    }

    public void attach(JmsSourceDefinition source, PhysicalTargetDefinition target, Wire wire) throws WiringException {
        URI serviceUri = target.getUri();
        ClassLoader sourceClassLoader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        TransactionType trxType = source.getTransactionType();
        WireHolder wireHolder = this.createWireHolder(wire, source, target, trxType);
        ResolvedObjects objects = this.resolveAdministeredObjects(source);
        ListenerConfiguration configuration = new ListenerConfiguration();
        try {
            ConnectionFactory requestFactory = objects.getRequestFactory();
            Destination requestDestination = objects.getRequestDestination();
            ConnectionFactory responseFactory = objects.getResponseFactory();
            Destination responseDestination = objects.getResponseDestination();
            ServiceListener listener = new ServiceListener(wireHolder, responseDestination, responseFactory, trxType, sourceClassLoader, this.monitor);
            configuration.setDestination(requestDestination);
            configuration.setFactory(requestFactory);
            configuration.setMessageListener(listener);
            configuration.setUri(serviceUri);
            configuration.setType(trxType);
            this.populateConfiguration(configuration, source.getMetadata());
            if (this.jmsHost.isRegistered(serviceUri)) {
                this.jmsHost.unregister(serviceUri);
            }
            this.jmsHost.register(configuration);
        }
        catch (JMSException e) {
            throw new WiringException((Throwable)e);
        }
    }

    private void populateConfiguration(ListenerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.SESSION == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        configuration.setTransactionTimeout(metadata.getTransactionTimeout());
    }

    public void detach(JmsSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        try {
            this.jmsHost.unregister(target.getUri());
        }
        catch (JMSException e) {
            throw new WiringException((Throwable)e);
        }
    }

    public void attachObjectFactory(JmsSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalTargetDefinition definition) throws WiringException {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(JmsSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    private ResolvedObjects resolveAdministeredObjects(JmsSourceDefinition source) throws WiringException {
        try {
            JmsBindingMetadata metadata = source.getMetadata();
            Hashtable<String, String> env = metadata.getEnv();
            ConnectionFactoryDefinition requestConnectionFactoryDefinition = metadata.getConnectionFactory();
            this.checkDefaults(source, requestConnectionFactoryDefinition);
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(requestConnectionFactoryDefinition, env);
            DestinationDefinition requestDestinationDefinition = metadata.getDestination();
            Destination requestDestination = this.resolver.resolve(requestDestinationDefinition, requestConnectionFactory, env);
            ConnectionFactory responseConnectionFactory = null;
            Destination responseDestination = null;
            if (metadata.isResponse()) {
                ConnectionFactoryDefinition responseConnectionFactoryDefinition = metadata.getResponseConnectionFactory();
                this.checkDefaults(source, responseConnectionFactoryDefinition);
                responseConnectionFactory = this.resolver.resolve(responseConnectionFactoryDefinition, env);
                DestinationDefinition responseDestinationDefinition = metadata.getResponseDestination();
                responseDestination = this.resolver.resolve(responseDestinationDefinition, responseConnectionFactory, env);
            }
            return new ResolvedObjects(requestConnectionFactory, requestDestination, responseConnectionFactory, responseDestination);
        }
        catch (JmsResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
    }

    private WireHolder createWireHolder(Wire wire, JmsSourceDefinition source, PhysicalTargetDefinition target, TransactionType trxType) throws WiringException {
        String callbackUri = null;
        if (target.getCallbackUri() != null) {
            callbackUri = target.getCallbackUri().toString();
        }
        JmsBindingMetadata metadata = source.getMetadata();
        List<OperationPayloadTypes> types = source.getPayloadTypes();
        CorrelationScheme correlationScheme = metadata.getCorrelationScheme();
        ArrayList<InvocationChainHolder> chainHolders = new ArrayList<InvocationChainHolder>();
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperationDefinition definition = chain.getPhysicalOperation();
            OperationPayloadTypes payloadType = this.resolveOperation(definition.getName(), types);
            if (payloadType == null) {
                throw new WiringException("Payload type not found for operation: " + definition.getName());
            }
            chainHolders.add(new InvocationChainHolder(chain, payloadType));
        }
        return new WireHolder(chainHolders, callbackUri, correlationScheme, trxType);
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private void checkDefaults(JmsSourceDefinition source, ConnectionFactoryDefinition connectionFactoryDefinition) {
        String name = connectionFactoryDefinition.getName();
        if (name == null) {
            if (TransactionType.GLOBAL == source.getTransactionType()) {
                connectionFactoryDefinition.setName("xaDefault");
            } else {
                connectionFactoryDefinition.setName("default");
            }
        }
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private ConnectionFactory responseFactory;
        private Destination requestDestination;
        private Destination responseDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, Destination requestDestination, ConnectionFactory responseFactory, Destination responseDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
            this.responseFactory = responseFactory;
            this.responseDestination = responseDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public ConnectionFactory getResponseFactory() {
            return this.responseFactory;
        }

        public Destination getRequestDestination() {
            return this.requestDestination;
        }

        public Destination getResponseDestination() {
            return this.responseDestination;
        }
    }
}

