/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.transaction.TransactionManager;
import org.fabric3.binding.jms.runtime.InterceptorConfiguration;
import org.fabric3.binding.jms.runtime.JmsInterceptor;
import org.fabric3.binding.jms.runtime.ResponseListener;
import org.fabric3.binding.jms.runtime.WireConfiguration;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.JmsBindingMetadata;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.binding.jms.spi.provision.JmsTargetDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsTargetWireAttacher
implements TargetWireAttacher<JmsTargetDefinition> {
    private AdministeredObjectResolver resolver;
    private TransactionManager tm;
    private ClassLoaderRegistry classLoaderRegistry;

    public JmsTargetWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference TransactionManager tm, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.resolver = resolver;
        this.tm = tm;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalSourceDefinition source, JmsTargetDefinition target, Wire wire) throws WiringException {
        WireConfiguration wireConfiguration = new WireConfiguration();
        ClassLoader targetClassLoader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        wireConfiguration.setClassloader(targetClassLoader);
        wireConfiguration.setTransactionManager(this.tm);
        wireConfiguration.setCorrelationScheme(target.getMetadata().getCorrelationScheme());
        wireConfiguration.setResponseTimeout(target.getMetadata().getResponseTimeout());
        wireConfiguration.setTransactionType(target.getTransactionType());
        this.resolveAdministeredObjects(target, wireConfiguration);
        List<OperationPayloadTypes> types = target.getPayloadTypes();
        for (InvocationChain chain : wire.getInvocationChains()) {
            InterceptorConfiguration configuration = new InterceptorConfiguration(wireConfiguration);
            PhysicalOperationDefinition op = chain.getPhysicalOperation();
            String operationName = op.getName();
            configuration.setOperationName(operationName);
            configuration.setOneWay(op.isOneWay());
            OperationPayloadTypes payloadTypes = this.resolveOperation(operationName, types);
            configuration.setPayloadType(payloadTypes);
            JmsInterceptor interceptor = new JmsInterceptor(configuration);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, JmsTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(JmsTargetDefinition target) throws WiringException {
        throw new UnsupportedOperationException();
    }

    private void resolveAdministeredObjects(JmsTargetDefinition target, WireConfiguration wireConfiguration) throws WiringException {
        JmsBindingMetadata metadata = target.getMetadata();
        Hashtable<String, String> env = metadata.getEnv();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        this.checkDefaults(target, connectionFactoryDefinition);
        try {
            ConnectionFactory requestConnectionFactory = this.resolver.resolve(connectionFactoryDefinition, env);
            DestinationDefinition destinationDefinition = metadata.getDestination();
            Destination requestDestination = this.resolver.resolve(destinationDefinition, requestConnectionFactory, env);
            wireConfiguration.setRequestConnectionFactory(requestConnectionFactory);
            wireConfiguration.setRequestDestination(requestDestination);
            if (metadata.isResponse()) {
                connectionFactoryDefinition = metadata.getResponseConnectionFactory();
                this.checkDefaults(target, connectionFactoryDefinition);
                ConnectionFactory responseConnectionFactory = this.resolver.resolve(connectionFactoryDefinition, env);
                destinationDefinition = metadata.getResponseDestination();
                Destination responseDestination = this.resolver.resolve(destinationDefinition, responseConnectionFactory, env);
                ResponseListener listener = new ResponseListener(responseDestination);
                wireConfiguration.setResponseListener(listener);
            }
        }
        catch (JmsResolutionException e) {
            throw new WiringException((Throwable)((Object)e));
        }
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private void checkDefaults(JmsTargetDefinition target, ConnectionFactoryDefinition connectionFactoryDefinition) {
        String name = connectionFactoryDefinition.getName();
        if (name == null) {
            if (TransactionType.GLOBAL == target.getTransactionType()) {
                connectionFactoryDefinition.setName("xaDefault");
            } else {
                connectionFactoryDefinition.setName("default");
            }
        }
    }
}

