/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;
import org.fabric3.binding.jms.runtime.container.TransactionException;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.spi.threadpool.ExecutionContext;
import org.fabric3.spi.threadpool.ExecutionContextTunnel;

@Management
public class AdaptiveMessageContainer {
    private static final int DEFAULT_TRX_TIMEOUT = 30;
    private int cacheLevel = 1;
    private int minReceivers = 1;
    private int maxReceivers = 1;
    private int idleLimit = 1;
    private int transactionTimeout = 30;
    private int receiveTimeout = this.transactionTimeout / 2;
    private int maxMessagesToProcess = -1;
    private long recoveryInterval = 5000L;
    private boolean durable = false;
    private boolean localDelivery;
    private TransactionType transactionType = TransactionType.NONE;
    private int acknowledgeMode = 1;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private String durableSubscriptionName;
    private String clientId;
    private String messageSelector;
    private MessageListener messageListener;
    private ExceptionListener exceptionListener;
    private Connection sharedConnection;
    private boolean initialized = false;
    private boolean running = false;
    private boolean sharedConnectionStarted = false;
    private int activeReceiverCount = 0;
    private final Object syncMonitor = new Object();
    protected final Object connectionSyncMonitor = new Object();
    private final Object recoverySyncMonitor = new Object();
    private Object recoveryMarker = new Object();
    private Set<MessageReceiver> receivers = new HashSet<MessageReceiver>();
    private List<Runnable> pausedWork = new LinkedList<Runnable>();
    private ExecutorService executorService;
    private TransactionManager tm;
    private MessageContainerMonitor monitor;
    private ContainerStatistics statistics = new ContainerStatistics();

    public AdaptiveMessageContainer(Destination destination, MessageListener listener, ConnectionFactory connectionFactory, ExecutorService executorService, TransactionManager tm, MessageContainerMonitor monitor) {
        this.executorService = executorService;
        this.destination = destination;
        this.messageListener = listener;
        this.durableSubscriptionName = listener.getClass().getName();
        this.connectionFactory = connectionFactory;
        this.tm = tm;
        this.monitor = monitor;
    }

    public void setLocalDelivery(boolean localDelivery) {
        this.localDelivery = localDelivery;
    }

    @ManagementOperation(description="The timeout value for receiving messages from a destination")
    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @ManagementOperation(description="The timeout value for receiving messages from a destination")
    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @ManagementOperation(description="The time to wait while making repeated recovery attempts")
    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    @ManagementOperation(description="The time to wait while making repeated recovery attempts")
    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setCacheLevel(int level) {
        this.cacheLevel = level;
    }

    @ManagementOperation(description="The cache level")
    public String getLevel() {
        if (this.cacheLevel == 1) {
            return "Connection";
        }
        if (this.cacheLevel == 2) {
            return "Session";
        }
        return "None";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The minimum number of receivers to create for a destination")
    public void setMinReceivers(int min) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.minReceivers = min;
            if (this.maxReceivers < min) {
                this.maxReceivers = min;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The minimum number of receivers to create for a destination")
    public int getMinReceivers() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.minReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of receivers to create for a destination")
    public void setMaxReceivers(int max) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.maxReceivers = max > this.minReceivers ? max : this.minReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of receivers to create for a destination")
    public int getMaxReceivers() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.maxReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of scheduled receivers")
    public int getReceiverCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.receivers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of receivers actively processing messages")
    public int getActiveReceiverCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.activeReceiverCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of paused receivers")
    public int getPausedReceiversCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.pausedWork.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of times a receiver can be marked idle during its execution window before it is removed from the work scheduler")
    public void setIdleLimit(int limit) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.idleLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of times a receiver can be marked idle during its execution window before it is removed from the work scheduler")
    public int getIdleLimit() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.idleLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of messages to process by a receivers")
    public void setMaxMessagesToProcess(int max) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.maxMessagesToProcess = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of messages to process by a receivers")
    public int getMaxMessagesToProcess() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.maxMessagesToProcess;
        }
    }

    public void setMessageSelectorProperty(String selector) {
        this.messageSelector = selector;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public void setDurableProperty(boolean durable) {
        this.durable = durable;
    }

    @ManagementOperation(description="If durable topic subscriptions are used")
    public boolean isDurable() {
        return this.durable;
    }

    public void setDurableSubscriptionNameProperty(String name) {
        this.durableSubscriptionName = name;
    }

    @ManagementOperation(description="The durable topic subscription name")
    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setTransactionTypeProperty(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @ManagementOperation(description="The transaction type")
    public String getTransactionType() {
        return this.transactionType.toString();
    }

    public void setAcknowledgeModeProperty(int mode) {
        this.acknowledgeMode = mode;
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    public String getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="True if the container is initialized")
    public boolean isInitialized() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="True if the container is running")
    public boolean isRunning() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JMSException {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.initialized = true;
                this.syncMonitor.notifyAll();
            }
            this.start();
            object = this.syncMonitor;
            synchronized (object) {
                for (int i = 0; i < this.minReceivers; ++i) {
                    this.addReceiver();
                }
            }
        }
        catch (JMSException e) {
            Object object = this.connectionSyncMonitor;
            synchronized (object) {
                JmsHelper.closeQuietly(this.sharedConnection);
                this.sharedConnection = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="Starts the containing processing messages")
    public void start() throws JMSException {
        if (this.cacheLevel >= 1) {
            this.getSharedConnection();
        }
        Object object = this.syncMonitor;
        synchronized (object) {
            this.running = true;
            this.syncMonitor.notifyAll();
            this.resumePausedWork();
        }
        if (this.cacheLevel >= 1) {
            this.startSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="Stops the containing processing messages")
    public void stop() throws JMSException {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.running = false;
            this.syncMonitor.notifyAll();
        }
        if (this.cacheLevel >= 1) {
            this.stopSharedConnection();
        }
    }

    @ManagementOperation(description="The current number of idle receivers")
    public int getIdleCount() {
        int count = 0;
        for (MessageReceiver receiver : this.receivers) {
            if (!receiver.isIdle()) continue;
            ++count;
        }
        return count;
    }

    @ManagementOperation(description="The time this container has been running")
    public long getTotalTime() {
        return this.statistics.getTotalTime();
    }

    @ManagementOperation(description="The number of messages received")
    public long getMessagesReceived() {
        return this.statistics.getMessagesReceived();
    }

    @ManagementOperation(description="The maximum number of active receivers reached")
    public int getMaxReceiversReached() {
        return this.statistics.getMaxReceivers();
    }

    @ManagementOperation(description="The total number of committed transactions")
    public int getTransactions() {
        return this.statistics.getTransactions();
    }

    @ManagementOperation(description="The total number of rolled back transactions")
    public int getTransactionsRolledBack() {
        return this.statistics.getTransactionsRolledBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean wasRunning;
        Object object = this.syncMonitor;
        synchronized (object) {
            wasRunning = this.running;
            this.running = false;
            this.initialized = false;
            this.syncMonitor.notifyAll();
        }
        if (wasRunning && this.cacheLevel >= 1) {
            this.stopSharedConnection();
        }
        try {
            object = this.syncMonitor;
            synchronized (object) {
                while (this.activeReceiverCount > 0) {
                    this.syncMonitor.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.cacheLevel >= 1) {
                Object object2 = this.connectionSyncMonitor;
                synchronized (object2) {
                    JmsHelper.closeQuietly(this.sharedConnection);
                    this.sharedConnection = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizePool() {
        if (this.isRunning()) {
            this.resumePausedWork();
            Object object = this.syncMonitor;
            synchronized (object) {
                if (this.receivers.size() < this.maxReceivers && this.getIdleCount() == 0) {
                    this.addReceiver();
                }
            }
        }
    }

    private void addReceiver() {
        MessageReceiver receiver = new MessageReceiver();
        if (this.rescheduleWork(receiver)) {
            this.receivers.add(receiver);
            if (this.statistics.getMaxReceivers() < this.receivers.size()) {
                this.statistics.incrementMaxReceivers();
            }
            this.monitor.increaseReceivers(this.receivers.size());
        }
    }

    private boolean shouldRescheduleReceiver(int count) {
        boolean extra = count >= this.idleLimit && this.getIdleCount() > 1;
        return this.receivers.size() <= (extra ? this.minReceivers : this.maxReceivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSharedConnection() throws JMSException {
        Object object = this.connectionSyncMonitor;
        synchronized (object) {
            JmsHelper.closeQuietly(this.sharedConnection);
            this.sharedConnection = this.createSharedConnection();
            if (this.sharedConnectionStarted) {
                this.sharedConnection.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getSharedConnection() throws JMSException {
        Object object = this.connectionSyncMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                this.sharedConnection = this.createSharedConnection();
            }
            return this.sharedConnection;
        }
    }

    private Connection createSharedConnection() throws JMSException {
        Connection connection = this.connectionFactory.createConnection();
        try {
            String clientId = this.getClientId();
            if (clientId != null) {
                connection.setClientID(clientId);
            }
            return connection;
        }
        catch (JMSException ex) {
            JmsHelper.closeQuietly(connection);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSharedConnection() {
        try {
            Object object = this.connectionSyncMonitor;
            synchronized (object) {
                this.sharedConnectionStarted = true;
                if (this.sharedConnection != null) {
                    this.sharedConnection.start();
                }
            }
        }
        catch (JMSException e) {
            this.monitor.debugError("Error starting connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSharedConnection() {
        try {
            Object object = this.connectionSyncMonitor;
            synchronized (object) {
                this.sharedConnectionStarted = false;
                if (this.sharedConnection != null) {
                    this.sharedConnection.stop();
                }
            }
        }
        catch (Exception e) {
            this.monitor.error("Error stopping connection", e);
        }
    }

    private void refreshConnection() {
        while (this.isRunning()) {
            try {
                if (this.cacheLevel >= 1) {
                    this.refreshSharedConnection();
                    break;
                }
                Connection con = this.connectionFactory.createConnection();
                JmsHelper.closeQuietly(con);
                break;
            }
            catch (Exception e) {
                this.monitor.error("Error refreshing connection for destination: " + this.destination, e);
                this.sleep();
            }
        }
    }

    private void handleReceiveException(Throwable e) {
        if (e instanceof JMSException && this.exceptionListener != null) {
            this.exceptionListener.onException((JMSException)e);
        }
        this.monitor.error("Listener threw an exception", e);
    }

    private boolean rescheduleWork(Runnable runnable) {
        if (this.isRunning()) {
            try {
                this.executorService.execute(runnable);
            }
            catch (RuntimeException e) {
                this.monitor.reject(e);
                this.pausedWork.add(runnable);
            }
            return true;
        }
        if (this.initialized) {
            this.pausedWork.add(runnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumePausedWork() {
        Object object = this.syncMonitor;
        synchronized (object) {
            if (!this.pausedWork.isEmpty()) {
                Iterator<Runnable> it = this.pausedWork.iterator();
                while (it.hasNext()) {
                    Runnable runnable = it.next();
                    try {
                        this.executorService.execute(runnable);
                        it.remove();
                    }
                    catch (RuntimeException e) {
                        this.monitor.reject(e);
                    }
                }
            }
        }
    }

    private void sleep() {
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void localCommitOrAcknowledge(Session session, Message message) throws JMSException {
        if (TransactionType.SESSION == this.transactionType) {
            session.commit();
            this.statistics.incrementTransactions();
        } else if (2 == session.getAcknowledgeMode()) {
            message.acknowledge();
        }
    }

    private void globalCommit() throws TransactionException {
        try {
            if (this.tm.getStatus() != 1) {
                this.tm.commit();
                this.statistics.incrementTransactions();
            } else {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
        catch (IllegalStateException e) {
            throw new TransactionException(e);
        }
        catch (SecurityException e) {
            throw new TransactionException(e);
        }
        catch (HeuristicMixedException e) {
            throw new TransactionException(e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionException(e);
        }
        catch (RollbackException e) {
            throw new TransactionException(e);
        }
    }

    private void globalRollback() throws TransactionException {
        try {
            if (this.tm.getStatus() != 6) {
                this.tm.rollback();
                this.statistics.incrementTransactionsRolledBack();
            }
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    private void localRollback(Session session) throws JMSException {
        if (TransactionType.SESSION == this.transactionType) {
            session.rollback();
            this.statistics.incrementTransactionsRolledBack();
        }
    }

    private Session createSession(Connection connection) throws JMSException {
        boolean transacted = TransactionType.SESSION == this.transactionType || TransactionType.GLOBAL == this.transactionType;
        return connection.createSession(transacted, this.acknowledgeMode);
    }

    private MessageConsumer createConsumer(Destination destination, Session session) throws JMSException {
        if (destination instanceof Topic && !(destination instanceof Queue)) {
            if (this.isDurable()) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.localDelivery);
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.localDelivery);
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    private class MessageReceiver
    implements Runnable {
        private Session session;
        private MessageConsumer consumer;
        private Object previousRecoveryMarker;
        private boolean previousSucceeded;
        private int idleWorkCount = 0;
        private volatile boolean idle = true;

        private MessageReceiver() {
        }

        public boolean isIdle() {
            return this.idle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object) {
                AdaptiveMessageContainer.this.activeReceiverCount++;
                AdaptiveMessageContainer.this.syncMonitor.notifyAll();
            }
            boolean messageReceived = false;
            try {
                if (AdaptiveMessageContainer.this.maxMessagesToProcess < 0) {
                    AdaptiveMessageContainer.this.monitor.scheduledReceiver(AdaptiveMessageContainer.this.destination.toString());
                    messageReceived = this.receiveLoop();
                } else {
                    for (int messageCount = 0; AdaptiveMessageContainer.this.isRunning() && messageCount < AdaptiveMessageContainer.this.maxMessagesToProcess; ++messageCount) {
                        messageReceived = this.receiveMessage() || messageReceived;
                    }
                }
            }
            catch (Throwable e) {
                this.closeResources();
                if (!this.previousSucceeded) {
                    AdaptiveMessageContainer.this.sleep();
                }
                this.previousSucceeded = false;
                AdaptiveMessageContainer.this.handleReceiveException(e);
                Object object2 = AdaptiveMessageContainer.this.recoverySyncMonitor;
                synchronized (object2) {
                    if (this.previousRecoveryMarker == AdaptiveMessageContainer.this.recoveryMarker) {
                        AdaptiveMessageContainer.this.refreshConnection();
                        AdaptiveMessageContainer.this.recoveryMarker = new Object();
                    }
                }
            }
            Object object3 = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object3) {
                AdaptiveMessageContainer.this.activeReceiverCount--;
                AdaptiveMessageContainer.this.syncMonitor.notifyAll();
            }
            this.idleWorkCount = !messageReceived ? ++this.idleWorkCount : 0;
            object3 = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object3) {
                if (!AdaptiveMessageContainer.this.shouldRescheduleReceiver(this.idleWorkCount) || !AdaptiveMessageContainer.this.rescheduleWork(this)) {
                    AdaptiveMessageContainer.this.receivers.remove(this);
                    AdaptiveMessageContainer.this.monitor.decreaseReceivers(AdaptiveMessageContainer.this.receivers.size());
                    AdaptiveMessageContainer.this.syncMonitor.notifyAll();
                    this.closeResources();
                } else if (AdaptiveMessageContainer.this.isRunning()) {
                    int nonPausedReceivers = AdaptiveMessageContainer.this.getReceiverCount() - AdaptiveMessageContainer.this.getPausedReceiversCount();
                    if (nonPausedReceivers < 1) {
                        AdaptiveMessageContainer.this.monitor.errorMessage("All receivers are paused, possibly as a result of rejected work.");
                    } else if (nonPausedReceivers < AdaptiveMessageContainer.this.getMinReceivers()) {
                        AdaptiveMessageContainer.this.monitor.errorMessage("The number is below the minimum threshold, possibly as a result of rejected work.");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean receiveLoop() throws JMSException, TransactionException {
            boolean received = false;
            boolean active = true;
            while (active) {
                ExecutionContext context = ExecutionContextTunnel.getThreadExecutionContext();
                Object object = AdaptiveMessageContainer.this.syncMonitor;
                synchronized (object) {
                    try {
                        if (context != null) {
                            context.start();
                        }
                        boolean interrupted = false;
                        boolean waiting = false;
                        while ((active = AdaptiveMessageContainer.this.isInitialized()) && !AdaptiveMessageContainer.this.isRunning()) {
                            if (interrupted) {
                                throw new IllegalStateException("Interrupted while waiting for restart");
                            }
                            if (!AdaptiveMessageContainer.this.isRunning()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!waiting && AdaptiveMessageContainer.this.isRunning()) {
                                AdaptiveMessageContainer.this.activeReceiverCount--;
                            }
                            waiting = true;
                            try {
                                AdaptiveMessageContainer.this.syncMonitor.wait();
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                interrupted = true;
                            }
                        }
                        if (waiting) {
                            AdaptiveMessageContainer.this.activeReceiverCount++;
                        }
                        if (context != null) {
                            context.stop();
                        }
                    }
                    finally {
                        if (context != null) {
                            context.clear();
                        }
                    }
                    if (!active) continue;
                }
                received = this.receiveMessage() || received;
            }
            return received;
        }

        private boolean receiveMessage() throws JMSException, TransactionException {
            this.setRecoveryMarker();
            boolean received = TransactionType.GLOBAL == AdaptiveMessageContainer.this.transactionType ? this.jtaReceiveMessage() : this.receive();
            this.previousSucceeded = true;
            return received;
        }

        private boolean jtaReceiveMessage() throws JMSException, TransactionException {
            try {
                int status = AdaptiveMessageContainer.this.tm.getStatus();
                boolean begun = false;
                if (6 == status) {
                    AdaptiveMessageContainer.this.tm.begin();
                    begun = true;
                }
                boolean received = this.receive();
                if (begun) {
                    AdaptiveMessageContainer.this.globalCommit();
                }
                return received;
            }
            catch (JMSException e) {
                AdaptiveMessageContainer.this.monitor.error("Error receiving message", e);
                AdaptiveMessageContainer.this.globalRollback();
            }
            catch (RuntimeException e) {
                AdaptiveMessageContainer.this.monitor.error("Error receiving message", e);
                AdaptiveMessageContainer.this.globalRollback();
            }
            catch (Error e) {
                AdaptiveMessageContainer.this.monitor.error("Error receiving message", e);
                AdaptiveMessageContainer.this.globalRollback();
            }
            catch (SystemException e) {
                throw new TransactionException(e);
            }
            catch (NotSupportedException e) {
                throw new TransactionException(e);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean receive() throws JMSException {
            MessageConsumer consumerToClose;
            Session sessionToClose;
            Connection connectionToUse;
            block27: {
                Message message;
                Session sessionToUse;
                block28: {
                    int timeout;
                    MessageConsumer consumerToUse;
                    block26: {
                        connectionToUse = null;
                        sessionToClose = null;
                        consumerToClose = null;
                        try {
                            sessionToUse = this.session;
                            if (sessionToUse == null) {
                                if (AdaptiveMessageContainer.this.cacheLevel >= 1) {
                                    connectionToUse = AdaptiveMessageContainer.this.getSharedConnection();
                                } else {
                                    connectionToUse = AdaptiveMessageContainer.this.connectionFactory.createConnection();
                                    connectionToUse.start();
                                }
                                sessionToClose = sessionToUse = AdaptiveMessageContainer.this.createSession(connectionToUse);
                            }
                            if ((consumerToUse = this.consumer) == null) {
                                consumerToClose = consumerToUse = AdaptiveMessageContainer.this.createConsumer(AdaptiveMessageContainer.this.destination, sessionToUse);
                            }
                            timeout = AdaptiveMessageContainer.this.receiveTimeout;
                            if (TransactionType.GLOBAL != AdaptiveMessageContainer.this.transactionType) break block26;
                            if (timeout == 0) {
                                timeout = AdaptiveMessageContainer.this.transactionTimeout / 2;
                            }
                            try {
                                AdaptiveMessageContainer.this.tm.setTransactionTimeout(AdaptiveMessageContainer.this.transactionTimeout);
                            }
                            catch (SystemException e) {
                                AdaptiveMessageContainer.this.monitor.error("Error setting transaction timeout", e);
                                boolean bl = false;
                                JmsHelper.closeQuietly(consumerToClose);
                                JmsHelper.closeQuietly(sessionToClose);
                                if (AdaptiveMessageContainer.this.cacheLevel == 0) {
                                    JmsHelper.closeQuietly(connectionToUse);
                                }
                                return bl;
                            }
                        }
                        catch (Throwable throwable) {
                            JmsHelper.closeQuietly(consumerToClose);
                            JmsHelper.closeQuietly(sessionToClose);
                            if (AdaptiveMessageContainer.this.cacheLevel == 0) {
                                JmsHelper.closeQuietly(connectionToUse);
                            }
                            throw throwable;
                        }
                    }
                    message = consumerToUse.receive((long)timeout);
                    if (message == null) break block27;
                    if (AdaptiveMessageContainer.this.isRunning()) break block28;
                    if (TransactionType.GLOBAL == AdaptiveMessageContainer.this.transactionType) {
                        try {
                            AdaptiveMessageContainer.this.tm.rollback();
                        }
                        catch (SystemException e) {
                            AdaptiveMessageContainer.this.monitor.error("Error setting rollback", e);
                        }
                    } else {
                        AdaptiveMessageContainer.this.localRollback(this.session);
                    }
                    this.idle = true;
                    boolean e = false;
                    JmsHelper.closeQuietly(consumerToClose);
                    JmsHelper.closeQuietly(sessionToClose);
                    if (AdaptiveMessageContainer.this.cacheLevel == 0) {
                        JmsHelper.closeQuietly(connectionToUse);
                    }
                    return e;
                }
                this.idle = false;
                AdaptiveMessageContainer.this.resizePool();
                try {
                    AdaptiveMessageContainer.this.messageListener.onMessage(message);
                    AdaptiveMessageContainer.this.statistics.incrementMessagesReceived();
                    AdaptiveMessageContainer.this.localCommitOrAcknowledge(sessionToUse, message);
                }
                catch (JMSException e) {
                    if (TransactionType.SESSION == AdaptiveMessageContainer.this.transactionType) {
                        AdaptiveMessageContainer.this.localRollback(sessionToUse);
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (TransactionType.SESSION == AdaptiveMessageContainer.this.transactionType) {
                        AdaptiveMessageContainer.this.localRollback(sessionToUse);
                    }
                    throw e;
                }
                boolean bl = true;
                JmsHelper.closeQuietly(consumerToClose);
                JmsHelper.closeQuietly(sessionToClose);
                if (AdaptiveMessageContainer.this.cacheLevel == 0) {
                    JmsHelper.closeQuietly(connectionToUse);
                }
                return bl;
            }
            this.idle = true;
            boolean bl = false;
            JmsHelper.closeQuietly(consumerToClose);
            JmsHelper.closeQuietly(sessionToClose);
            if (AdaptiveMessageContainer.this.cacheLevel == 0) {
                JmsHelper.closeQuietly(connectionToUse);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeResources() {
            Object object = AdaptiveMessageContainer.this.connectionSyncMonitor;
            synchronized (object) {
                JmsHelper.closeQuietly(this.consumer);
                JmsHelper.closeQuietly(this.session);
            }
            this.consumer = null;
            this.session = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRecoveryMarker() {
            Object object = AdaptiveMessageContainer.this.recoverySyncMonitor;
            synchronized (object) {
                this.previousRecoveryMarker = AdaptiveMessageContainer.this.recoveryMarker;
            }
        }
    }
}

