/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.host;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.transaction.TransactionManager;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;
import org.fabric3.binding.jms.runtime.host.HostMonitor;
import org.fabric3.binding.jms.runtime.host.JmsHost;
import org.fabric3.binding.jms.runtime.host.ListenerConfiguration;
import org.fabric3.binding.jms.spi.common.TransactionType;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.Fabric3EventListener;
import org.fabric3.spi.event.RuntimeStart;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.transport.Transport;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Service(interfaces={JmsHost.class, Transport.class})
public class JmsHostImpl
implements JmsHost,
Transport,
Fabric3EventListener<RuntimeStart> {
    private Map<URI, AdaptiveMessageContainer> containers = new ConcurrentHashMap<URI, AdaptiveMessageContainer>();
    private boolean started;
    private EventService eventService;
    private ExecutorService executorService;
    private TransactionManager tm;
    private MessageContainerMonitor containerMonitor;
    private ManagementService managementService;
    private HostMonitor monitor;

    public JmsHostImpl(@Reference EventService eventService, @Reference ExecutorService executorService, @Reference TransactionManager tm, @Reference ManagementService managementService, @Monitor MessageContainerMonitor containerMonitor, @Monitor HostMonitor monitor) {
        this.eventService = eventService;
        this.executorService = executorService;
        this.tm = tm;
        this.managementService = managementService;
        this.containerMonitor = containerMonitor;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.eventService.subscribe(RuntimeStart.class, (Fabric3EventListener)this);
    }

    @Destroy
    public void destroy() throws JMSException {
        for (AdaptiveMessageContainer container : this.containers.values()) {
            container.stop();
        }
        for (AdaptiveMessageContainer container : this.containers.values()) {
            container.shutdown();
        }
        this.started = false;
    }

    public void suspend() {
        if (!this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (JMSException e) {
                this.monitor.error("Error stopping service listener: " + entry.getKey(), e);
            }
        }
        this.started = false;
    }

    public void resume() {
        if (this.started) {
            return;
        }
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                entry.getValue().start();
            }
            catch (JMSException e) {
                this.monitor.error("Error starting service listener: " + entry.getKey(), e);
            }
        }
        this.started = true;
    }

    public void onEvent(RuntimeStart event) {
        for (Map.Entry<URI, AdaptiveMessageContainer> entry : this.containers.entrySet()) {
            try {
                entry.getValue().initialize();
                this.monitor.registerListener(entry.getKey());
            }
            catch (JMSException e) {
                this.monitor.error("Error starting service listener: " + entry.getKey(), e);
            }
        }
        this.started = true;
    }

    @Override
    public boolean isRegistered(URI serviceUri) {
        return this.containers.containsKey(serviceUri);
    }

    @Override
    public void register(ListenerConfiguration configuration) throws JMSException {
        Destination destination = configuration.getDestination();
        MessageListener listener = configuration.getMessageListener();
        ConnectionFactory factory = configuration.getFactory();
        TransactionType type = configuration.getType();
        URI serviceUri = configuration.getUri();
        AdaptiveMessageContainer container = new AdaptiveMessageContainer(destination, listener, factory, this.executorService, this.tm, this.containerMonitor);
        if (TransactionType.GLOBAL == type) {
            container.setTransactionTypeProperty(TransactionType.GLOBAL);
            container.setAcknowledgeModeProperty(1);
        }
        container.setCacheLevel(configuration.getCacheLevel());
        container.setExceptionListener(configuration.getExceptionListener());
        container.setMaxMessagesToProcess(configuration.getMaxMessagesToProcess());
        container.setCacheLevel(configuration.getCacheLevel());
        container.setMaxReceivers(configuration.getMaxReceivers());
        container.setMinReceivers(configuration.getMinReceivers());
        container.setRecoveryInterval(configuration.getRecoveryInterval());
        container.setIdleLimit(configuration.getIdleLimit());
        container.setReceiveTimeout(configuration.getReceiveTimeout());
        container.setRecoveryInterval(configuration.getRecoveryInterval());
        this.containers.put(serviceUri, container);
        try {
            String encoded = this.encode(serviceUri);
            this.managementService.export(serviceUri.getFragment(), encoded, "JMS message container", (Object)container);
        }
        catch (ManagementException e) {
            throw new JMSException(e.getMessage());
        }
        if (this.started) {
            container.initialize();
            this.monitor.registerListener(serviceUri);
        }
    }

    @Override
    public void unregister(URI serviceUri) throws JMSException {
        AdaptiveMessageContainer container = this.containers.remove(serviceUri);
        if (container != null) {
            container.shutdown();
            try {
                String encoded = this.encode(serviceUri);
                this.managementService.export(serviceUri.getFragment(), encoded, "JMS message container", (Object)container);
            }
            catch (ManagementException e) {
                throw new JMSException(e.getMessage());
            }
            this.monitor.unRegisterListener(serviceUri);
        }
    }

    private String encode(URI serviceUri) {
        return "JMS/message containers/" + serviceUri.getPath().substring(1);
    }
}

