/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;

    public AlwaysConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition, Hashtable<String, String> env) throws JmsResolutionException {
        String name = definition.getName();
        try {
            Map<String, String> props = definition.getProperties();
            String className = props.get("class");
            if (className == null) {
                throw new JmsResolutionException("The 'class' attribute must be set for the connection factory: " + name);
            }
            ConnectionFactory factory = (ConnectionFactory)Class.forName(className).newInstance();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(factory.getClass()).getPropertyDescriptors()) {
                String propName = pd.getName();
                String propValue = props.get(propName);
                Method writeMethod = pd.getWriteMethod();
                if (propValue == null || writeMethod == null) continue;
                writeMethod.invoke((Object)factory, propValue);
            }
            return this.manager.register(name, factory);
        }
        catch (InstantiationException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, e);
        }
        catch (ClassNotFoundException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, e);
        }
        catch (IntrospectionException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, e);
        }
        catch (InvocationTargetException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, e);
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + name, (Throwable)((Object)e));
        }
    }
}

