/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.JndiHelper;
import org.fabric3.binding.jms.runtime.resolver.connectionfactory.AlwaysConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryResolver;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfNotExistConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryStrategy always;
    private ConnectionFactoryManager manager;
    private List<ProviderConnectionFactoryResolver> resolvers;

    public IfNotExistConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.always = new AlwaysConnectionFactoryStrategy(manager);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ProviderConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition, Hashtable<String, String> env) throws JmsResolutionException {
        String name = definition.getName();
        try {
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            for (ProviderConnectionFactoryResolver resolver : this.resolvers) {
                factory = resolver.resolve(definition);
                if (factory == null) continue;
                this.manager.register(name, factory);
                return factory;
            }
            try {
                factory = (ConnectionFactory)JndiHelper.lookup(name, env);
            }
            catch (NoInitialContextException e) {
                factory = this.always.getConnectionFactory(definition, env);
            }
            catch (NameNotFoundException ex) {
                factory = this.always.getConnectionFactory(definition, env);
            }
            return this.manager.register(name, factory);
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, (Throwable)((Object)e));
        }
        catch (NamingException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, e);
        }
    }
}

