/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.JndiHelper;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryResolver;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeverConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;
    private List<ProviderConnectionFactoryResolver> resolvers;

    public NeverConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ProviderConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition, Hashtable<String, String> env) throws JmsResolutionException {
        String name = definition.getName();
        try {
            ProviderConnectionFactoryResolver resolver;
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            Iterator<ProviderConnectionFactoryResolver> i$ = this.resolvers.iterator();
            while (i$.hasNext() && (factory = (resolver = i$.next()).resolve(definition)) == null) {
            }
            if (factory == null) {
                factory = (ConnectionFactory)JndiHelper.lookup(name, env);
            }
            return this.manager.register(name, factory, Collections.<String, String>emptyMap());
        }
        catch (NameNotFoundException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, e);
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, (Throwable)((Object)e));
        }
        catch (NamingException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, e);
        }
    }
}

