/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.destination;

import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.fabric3.binding.jms.runtime.resolver.JndiHelper;
import org.fabric3.binding.jms.runtime.resolver.destination.AlwaysDestinationStrategy;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.runtime.JmsResolutionException;
import org.fabric3.binding.jms.spi.runtime.ProviderDestinationResolver;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfNotExistDestinationStrategy
implements DestinationStrategy {
    private DestinationStrategy always = new AlwaysDestinationStrategy();
    private List<ProviderDestinationResolver> resolvers;

    @Reference(required=false)
    public void setResolvers(List<ProviderDestinationResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public Destination getDestination(DestinationDefinition definition, ConnectionFactory factory, Hashtable<String, String> env) throws JmsResolutionException {
        try {
            for (ProviderDestinationResolver resolver : this.resolvers) {
                Destination destination = resolver.resolve(definition);
                if (destination == null) continue;
                return destination;
            }
            return (Destination)JndiHelper.lookup(definition.getName(), env);
        }
        catch (NoInitialContextException e) {
            return this.always.getDestination(definition, factory, env);
        }
        catch (NameNotFoundException ex) {
            return this.always.getDestination(definition, factory, env);
        }
        catch (NamingException e) {
            throw new JmsResolutionException("Unable to resolve destination: " + definition.getName(), e);
        }
    }
}

