/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.spi.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.fabric3.binding.jms.spi.common.CacheLevel;
import org.fabric3.binding.jms.spi.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.spi.common.CorrelationScheme;
import org.fabric3.binding.jms.spi.common.DestinationDefinition;
import org.fabric3.binding.jms.spi.common.HeadersDefinition;
import org.fabric3.binding.jms.spi.common.OperationPropertiesDefinition;
import org.fabric3.binding.jms.spi.common.ResponseDefinition;
import org.fabric3.model.type.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsBindingMetadata
extends ModelObject {
    private static final long serialVersionUID = 4623441503097788831L;
    private CorrelationScheme correlationScheme = CorrelationScheme.MESSAGE_ID;
    private String initialContextFactory;
    private String jndiUrl;
    private DestinationDefinition destination;
    private ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
    private ResponseDefinition response;
    private HeadersDefinition headers;
    private Map<String, OperationPropertiesDefinition> operationProperties;
    private CacheLevel cacheLevel;
    private int minReceivers = 1;
    private int maxReceivers = 1;
    private int idleLimit = 1;
    private int transactionTimeout = 30;
    private int receiveTimeout = this.transactionTimeout / 2 * 1000;
    private int responseTimeout = 600000;
    private int maxMessagesToProcess = -1;
    private long recoveryInterval = 5000L;
    private boolean durable = false;
    private boolean localDelivery;
    private String clientId;
    private String durableSubscriptionName;

    public ConnectionFactoryDefinition getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactoryDefinition connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public CorrelationScheme getCorrelationScheme() {
        return this.correlationScheme;
    }

    public void setCorrelationScheme(CorrelationScheme correlationScheme) {
        this.correlationScheme = correlationScheme;
    }

    public DestinationDefinition getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationDefinition destination) {
        this.destination = destination;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public String getJndiUrl() {
        return this.jndiUrl;
    }

    public void setJndiUrl(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public ResponseDefinition getResponse() {
        return this.response;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public DestinationDefinition getResponseDestination() {
        return this.response.getDestination();
    }

    public ConnectionFactoryDefinition getResponseConnectionFactory() {
        return this.response.getConnectionFactory();
    }

    public Hashtable<String, String> getEnv() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.jndiUrl != null) {
            props.put("java.naming.provider.url", this.getJndiUrl());
        }
        if (this.initialContextFactory != null) {
            props.put("java.naming.factory.initial", this.getInitialContextFactory());
        }
        return props;
    }

    public HeadersDefinition getHeaders() {
        return this.headers;
    }

    public void setHeaders(HeadersDefinition headers) {
        this.headers = headers;
    }

    public Map<String, OperationPropertiesDefinition> getOperationProperties() {
        if (this.operationProperties == null) {
            return Collections.emptyMap();
        }
        return this.operationProperties;
    }

    public void addOperationProperties(String name, OperationPropertiesDefinition operationProperties) {
        if (this.operationProperties == null) {
            this.operationProperties = new HashMap<String, OperationPropertiesDefinition>();
        }
        this.operationProperties.put(name, operationProperties);
    }

    public boolean isResponse() {
        return this.response != null;
    }

    public CacheLevel getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(CacheLevel cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getMinReceivers() {
        return this.minReceivers;
    }

    public void setMinReceivers(int minReceivers) {
        this.minReceivers = minReceivers;
    }

    public int getMaxReceivers() {
        return this.maxReceivers;
    }

    public void setMaxReceivers(int maxReceivers) {
        this.maxReceivers = maxReceivers;
    }

    public int getIdleLimit() {
        return this.idleLimit;
    }

    public void setIdleLimit(int idleLimit) {
        this.idleLimit = idleLimit;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public int getMaxMessagesToProcess() {
        return this.maxMessagesToProcess;
    }

    public void setMaxMessagesToProcess(int maxMessagesToProcess) {
        this.maxMessagesToProcess = maxMessagesToProcess;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isLocalDelivery() {
        return this.localDelivery;
    }

    public void setLocalDelivery(boolean localDelivery) {
        this.localDelivery = localDelivery;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }
}

