/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.spi.common;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsURIMetadata {
    public static final String CONNECTIONFACORYNAME = "connectionFactoryName";
    public static final String DESTINATIONTYPE = "destinationType";
    public static final String DELIVERYMODE = "deliveryMode";
    public static final String TIMETOLIVE = "timeToLive";
    public static final String PRIORITY = "priority";
    public static final String RESPONSEDESTINAT = "responseDestination";
    private String destination;
    private Map<String, String> properties;

    public String getDestination() {
        return this.destination;
    }

    private JmsURIMetadata(String destination) {
        this.destination = destination;
        this.properties = new HashMap<String, String>();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static JmsURIMetadata parseURI(String uri) throws URISyntaxException {
        boolean matches = Pattern.matches("jms:(.*?)[\\?(.*?)=(.*?)((&(.*?)=(.*?))*)]?", uri);
        if (!matches) {
            throw new URISyntaxException(uri, "Not a valid URI format for binding.jms");
        }
        return JmsURIMetadata.doParse(uri);
    }

    private static JmsURIMetadata doParse(String uri) {
        StringTokenizer token = new StringTokenizer(uri, ":?=&");
        String propertyName = null;
        int pos = 0;
        JmsURIMetadata result = null;
        while (token.hasMoreTokens()) {
            String current = token.nextToken();
            if (1 == pos) {
                result = new JmsURIMetadata(current);
            } else if (pos % 2 == 0) {
                propertyName = current;
            } else if (0 != pos) {
                assert (propertyName != null);
                assert (result != null);
                result.properties.put(propertyName.trim(), current.trim());
            }
            ++pos;
        }
        return result;
    }
}

