/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.java.introspection.ImplementationArtifactNotFound;
import org.fabric3.implementation.java.introspection.JavaImplementationProcessor;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidImplementation;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImplementationProcessorImpl
implements JavaImplementationProcessor {
    private final ClassVisitor<JavaImplementation> classVisitor;
    private final HeuristicProcessor<JavaImplementation> heuristic;
    private final IntrospectionHelper helper;

    public JavaImplementationProcessorImpl(@Reference(name="classVisitor") ClassVisitor<JavaImplementation> classVisitor, @Reference(name="heuristic") HeuristicProcessor<JavaImplementation> heuristic, @Reference(name="helper") IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.heuristic = heuristic;
        this.helper = helper;
    }

    public void introspect(JavaImplementation implementation, IntrospectionContext context) {
        Class implClass;
        String implClassName = implementation.getImplementationClass();
        InjectingComponentType componentType = new InjectingComponentType(implClassName);
        componentType.setScope("STATELESS");
        implementation.setComponentType((ComponentType)componentType);
        ClassLoader cl = context.getClassLoader();
        try {
            implClass = this.helper.loadClass(implClassName, cl);
        }
        catch (ImplementationNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError) {
                context.addError((ValidationFailure)new ImplementationArtifactNotFound(implClassName, e.getCause().getMessage()));
            } else {
                context.addError((ValidationFailure)new ImplementationArtifactNotFound(implClassName));
            }
            return;
        }
        if (implClass.isInterface()) {
            InvalidImplementation failure = new InvalidImplementation("Implementation class is an interface", implClassName);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping mapping = context.getTypeMapping(implClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(implClass, mapping);
            this.helper.resolveTypeParameters(implClass, mapping);
        }
        try {
            this.classVisitor.visit((Implementation)implementation, implClass, context);
            this.heuristic.applyHeuristics((Implementation)implementation, implClass, context);
        }
        catch (NoClassDefFoundError e) {
            context.addError((ValidationFailure)new ImplementationArtifactNotFound(implClassName, e.getMessage()));
        }
    }
}

