/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.implementation.java.provision.JavaConnectionTargetDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.component.InvokerEventStreamHandler;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.type.java.Signature;
import org.fabric3.spi.util.UriHelper;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaTargetConnectionAttacher
implements TargetConnectionAttacher<JavaConnectionTargetDefinition> {
    private ComponentManager manager;
    private ClassLoaderRegistry classLoaderRegistry;

    public JavaTargetConnectionAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalConnectionSourceDefinition source, JavaConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        URI targetUri = target.getTargetUri();
        URI targetName = UriHelper.getDefragmentedName((URI)targetUri);
        JavaComponent component = (JavaComponent)this.manager.getComponent(targetName);
        if (component == null) {
            throw new ConnectionAttachException("Target component not found: " + targetName);
        }
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        Method method = this.loadMethod(target, component);
        InvokerEventStreamHandler handler = new InvokerEventStreamHandler(method, (AtomicComponent)component, component.getScopeContainer(), loader);
        for (EventStream stream : connection.getEventStreams()) {
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    public void detach(PhysicalConnectionSourceDefinition source, JavaConnectionTargetDefinition target) throws ConnectionAttachException {
    }

    private Method loadMethod(JavaConnectionTargetDefinition target, JavaComponent component) throws ConnectionAttachException {
        Signature signature = target.getConsumerSignature();
        Class implementationClass = component.getImplementationClass();
        try {
            return signature.getMethod(implementationClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
    }
}

