/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerFactory;
import org.fabric3.spi.transform.TransformerRegistry;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransformerRegistry
implements TransformerRegistry {
    private Map<Key, SingleTypeTransformer<?, ?>> transformers = new HashMap();
    private List<TransformerFactory> factories = new ArrayList<TransformerFactory>();

    @Reference(required=false)
    public void setTransformers(List<SingleTypeTransformer<?, ?>> transformers) {
        for (SingleTypeTransformer<?, ?> transformer : transformers) {
            Key pair = new Key(transformer.getSourceType(), transformer.getTargetType());
            this.transformers.put(pair, transformer);
        }
    }

    @Reference(required=false)
    public void setFactories(List<TransformerFactory> factories) {
        this.factories = factories;
    }

    public Transformer<?, ?> getTransformer(DataType<?> source, DataType<?> target, List<Class<?>> inTypes, List<Class<?>> outTypes) throws TransformationException {
        Key key = new Key(source, target);
        Transformer transformer = (Transformer)this.transformers.get(key);
        if (transformer != null) {
            return transformer;
        }
        for (TransformerFactory factory : this.factories) {
            boolean canTransform = factory.canTransform(source, target);
            if (!canTransform) continue;
            return factory.create(source, target, inTypes, outTypes);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        private final DataType<?> source;
        private final DataType<?> target;

        public Key(DataType<?> source, DataType<?> target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.source.equals(that.source) && this.target.equals(that.target);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }
}

