/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property2DateTransformer
implements SingleTypeTransformer<Node, Date> {
    private static final JavaClass<Date> TARGET = new JavaClass(Date.class);
    private final DateFormat dateFormatter = new SimpleDateFormat("yyy-MM-d'T'HH:mm:ss'Z'");

    public DataType<?> getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType<?> getTargetType() {
        return TARGET;
    }

    public Property2DateTransformer() {
        this.dateFormatter.setLenient(false);
    }

    public Date transform(Node node, ClassLoader loader) throws TransformationException {
        try {
            return this.dateFormatter.parse(node.getTextContent());
        }
        catch (ParseException pe) {
            throw new TransformationException("Unsupported Date Format ", (Throwable)pe);
        }
    }
}

