/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.string2java;

import javax.xml.namespace.QName;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDSimpleType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2ClassTransformer
implements SingleTypeTransformer<String, Class<?>> {
    private static final XSDSimpleType SOURCE = new XSDSimpleType(String.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
    private static final JavaClass<Class> TARGET = new JavaClass(Class.class);
    private ClassLoaderRegistry classLoaderRegistry;

    public String2ClassTransformer(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public DataType<?> getSourceType() {
        return SOURCE;
    }

    public DataType<?> getTargetType() {
        return TARGET;
    }

    public Class<?> transform(String source, ClassLoader loader) throws TransformationException {
        try {
            return this.classLoaderRegistry.loadClass(loader, source);
        }
        catch (ClassNotFoundException e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

