/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.deployment.executor;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.deployment.command.DeploymentCommand;
import org.fabric3.federation.deployment.command.DeploymentErrorResponse;
import org.fabric3.federation.deployment.command.DeploymentResponse;
import org.fabric3.federation.deployment.command.SerializedDeploymentUnit;
import org.fabric3.federation.deployment.coordinator.DeploymentCache;
import org.fabric3.federation.deployment.coordinator.RollbackException;
import org.fabric3.federation.deployment.coordinator.RollbackService;
import org.fabric3.federation.deployment.executor.DeploymentCommandExecutorMonitor;
import org.fabric3.host.Fabric3Exception;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.classloader.SerializationService;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.command.CompensatableCommand;
import org.fabric3.spi.command.Response;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DeploymentCommandExecutor
implements CommandExecutor<DeploymentCommand> {
    private CommandExecutorRegistry executorRegistry;
    private DeploymentCache cache;
    private SerializationService serializationService;
    private RollbackService rollbackService;
    private ExecutorService executorService;
    private DeploymentCommandExecutorMonitor monitor;
    private ScopeRegistry scopeRegistry;
    private BlockingQueue<DeploymentCommand> deploymentQueue;
    private MessagePump messagePump;

    public DeploymentCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Reference DeploymentCache cache, @Reference SerializationService serializationService, @Reference RollbackService rollbackService, @Reference ExecutorService executorService, @Monitor DeploymentCommandExecutorMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.cache = cache;
        this.serializationService = serializationService;
        this.rollbackService = rollbackService;
        this.executorService = executorService;
        this.monitor = monitor;
        this.scopeRegistry = scopeRegistry;
        this.deploymentQueue = new LinkedBlockingDeque<DeploymentCommand>();
    }

    @Init
    public void init() {
        this.messagePump = new MessagePump();
        this.executorService.execute(this.messagePump);
        this.executorRegistry.register(DeploymentCommand.class, (CommandExecutor)this);
    }

    @Destroy
    public void destroy() {
        this.messagePump.stop();
    }

    public synchronized void execute(DeploymentCommand command) throws ExecutionException {
        try {
            this.monitor.received();
            this.deploymentQueue.put(command);
            DeploymentResponse response = new DeploymentResponse();
            command.setResponse(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagePump
    implements Runnable {
        private AtomicBoolean active = new AtomicBoolean(true);

        private MessagePump() {
        }

        @Override
        public void run() {
            this.doRun();
            if (this.active.get()) {
                DeploymentCommandExecutor.this.executorService.execute(this);
            }
        }

        public void doRun() {
            try {
                DeploymentCommand command = (DeploymentCommand)DeploymentCommandExecutor.this.deploymentQueue.poll(1000L, TimeUnit.MILLISECONDS);
                if (command == null) {
                    return;
                }
                DeploymentCommandExecutor.this.monitor.processing();
                SerializedDeploymentUnit currentDeploymentUnit = command.getCurrentDeploymentUnit();
                byte[] serializedProvisionCommands = currentDeploymentUnit.getProvisionCommands();
                boolean result = this.execute(serializedProvisionCommands, command);
                if (!result) {
                    return;
                }
                byte[] serializedExtensionCommands = currentDeploymentUnit.getExtensionCommands();
                result = this.execute(serializedExtensionCommands, command);
                if (!result) {
                    return;
                }
                byte[] serializedCommands = currentDeploymentUnit.getCommands();
                result = this.execute(serializedCommands, command);
                if (!result) {
                    return;
                }
                this.cacheDeployment(command);
            }
            catch (RuntimeException e) {
                DeploymentCommandExecutor.this.monitor.errorMessage("Error performing deployment", e);
                throw e;
            }
            catch (InterruptedException e) {
                this.active.set(false);
                Thread.currentThread().interrupt();
            }
        }

        private void stop() {
            this.active.set(false);
        }

        private boolean execute(byte[] serializedCommands, DeploymentCommand command) {
            int marker = 0;
            List commands = null;
            try {
                commands = (List)DeploymentCommandExecutor.this.serializationService.deserialize(List.class, serializedCommands);
                for (CompensatableCommand cmd : commands) {
                    DeploymentCommandExecutor.this.executorRegistry.execute((Command)cmd);
                    ++marker;
                }
                if (!commands.isEmpty()) {
                    DeploymentCommandExecutor.this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
                }
                return true;
            }
            catch (IOException e) {
                DeploymentCommandExecutor.this.monitor.error(e);
                DeploymentErrorResponse response = new DeploymentErrorResponse(e);
                command.setResponse((Response)response);
                return false;
            }
            catch (ClassNotFoundException e) {
                DeploymentCommandExecutor.this.monitor.error(e);
                DeploymentErrorResponse response = new DeploymentErrorResponse(e);
                command.setResponse((Response)response);
                return false;
            }
            catch (InstanceLifecycleException e) {
                return this.handleRollback(command, marker, commands, (Fabric3Exception)e);
            }
            catch (ExecutionException e) {
                return this.handleRollback(command, marker, commands, (Fabric3Exception)e);
            }
        }

        private void cacheDeployment(DeploymentCommand command) {
            String zone = command.getZone();
            SerializedDeploymentUnit fullDeploymentUnit = command.getFullDeploymentUnit();
            DeploymentCommand deploymentCommand = new DeploymentCommand(zone, fullDeploymentUnit, fullDeploymentUnit);
            DeploymentCommandExecutor.this.cache.cache(deploymentCommand);
        }

        private boolean handleRollback(DeploymentCommand command, int marker, List<CompensatableCommand> commands, Fabric3Exception e) {
            DeploymentCommandExecutor.this.monitor.error((Throwable)e);
            try {
                DeploymentCommandExecutor.this.rollbackService.rollback(commands, marker);
            }
            catch (RollbackException e1) {
                DeploymentCommandExecutor.this.monitor.error((Throwable)e);
            }
            DeploymentErrorResponse response = new DeploymentErrorResponse((Exception)e);
            command.setResponse((Response)response);
            return false;
        }
    }
}

