/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.contribution.archive.ClasspathProcessor;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.osoa.sca.annotations.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ClasspathProcessorRegistryImpl
implements ClasspathProcessorRegistry {
    private List<ClasspathProcessor> processors = new ArrayList<ClasspathProcessor>();

    public void register(ClasspathProcessor processor) {
        this.processors.add(processor);
    }

    public void unregister(ClasspathProcessor processor) {
        this.processors.remove(processor);
    }

    public List<URL> process(URL url) throws IOException {
        for (ClasspathProcessor processor : this.processors) {
            if (!processor.canProcess(url)) continue;
            return processor.process(url);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url);
        return urls;
    }
}

