/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.fabric3.spi.artifact.ArtifactCache;
import org.fabric3.spi.artifact.CacheException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.ContributionResolverExtension;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResolutionException;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DefaultContributionResolver
implements ContributionResolver {
    private MetaDataStore store;
    private ArtifactCache cache;
    private List<ContributionResolverExtension> extensions;

    @Constructor
    public DefaultContributionResolver(@Reference MetaDataStore store, @Reference ArtifactCache cache) {
        this.store = store;
        this.cache = cache;
        this.extensions = Collections.emptyList();
    }

    @Reference(required=false)
    public void setExtensions(List<ContributionResolverExtension> extensions) {
        this.extensions = extensions;
    }

    public URL resolve(URI uri) throws ResolutionException {
        Contribution contribution = this.store.find(uri);
        if (contribution != null) {
            return contribution.getLocation();
        }
        URL url = this.cache.get(uri);
        if (url != null) {
            return url;
        }
        for (ContributionResolverExtension extension : this.extensions) {
            InputStream stream = extension.resolve(uri);
            if (stream == null) continue;
            try {
                return this.cache.cache(uri, stream);
            }
            catch (CacheException e) {
                throw new ResolutionException("Error resolving contribution: " + uri, (Throwable)e);
            }
        }
        throw new ResolutionException("Contribution not found: " + uri);
    }

    public void release(URI uri) throws ResolutionException {
        try {
            this.cache.remove(uri);
        }
        catch (CacheException e) {
            throw new ResolutionException("Error releasing artifact: " + uri, (Throwable)e);
        }
    }
}

