/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.contribution.CyclicDependencyException;
import org.fabric3.contribution.DependencyException;
import org.fabric3.contribution.DependencyService;
import org.fabric3.contribution.UnresolvableImportException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.util.graph.CycleDetector;
import org.fabric3.util.graph.CycleDetectorImpl;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.DirectedGraphImpl;
import org.fabric3.util.graph.Edge;
import org.fabric3.util.graph.EdgeImpl;
import org.fabric3.util.graph.GraphException;
import org.fabric3.util.graph.TopologicalSorter;
import org.fabric3.util.graph.TopologicalSorterImpl;
import org.fabric3.util.graph.Vertex;
import org.fabric3.util.graph.VertexImpl;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyServiceImpl
implements DependencyService {
    private CycleDetector<Contribution> detector;
    private TopologicalSorter<Contribution> sorter;
    private MetaDataStore store;

    public DependencyServiceImpl(@Reference MetaDataStore store) {
        this.store = store;
        this.detector = new CycleDetectorImpl();
        this.sorter = new TopologicalSorterImpl();
    }

    @Override
    public List<Contribution> order(List<Contribution> contributions) throws DependencyException {
        DirectedGraphImpl dag = new DirectedGraphImpl();
        for (Contribution contribution : contributions) {
            dag.add((Vertex)new VertexImpl((Object)contribution));
        }
        for (Vertex source : dag.getVertices()) {
            Contribution contribution = (Contribution)source.getEntity();
            ContributionManifest manifest = contribution.getManifest();
            URI uri = contribution.getUri();
            for (Import imprt : manifest.getImports()) {
                List<Vertex<Contribution>> sinks = this.findTargetVertex((DirectedGraph<Contribution>)dag, uri, imprt);
                if (sinks.isEmpty()) {
                    List resolvedContributions = this.store.resolve(uri, imprt);
                    for (Contribution resolved : resolvedContributions) {
                        if (resolved == null || ContributionState.INSTALLED == resolved.getState()) continue;
                        throw new DependencyException("Contribution " + contribution.getUri() + " imports " + resolved.getUri() + " which is not installed");
                    }
                    if (!resolvedContributions.isEmpty()) continue;
                    throw new UnresolvableImportException("Unable to resolve import " + imprt + " in " + uri, imprt);
                }
                for (Vertex<Contribution> sink : sinks) {
                    EdgeImpl edge = new EdgeImpl(source, sink);
                    dag.add((Edge)edge);
                }
            }
        }
        List cycles = this.detector.findCycles((DirectedGraph)dag);
        if (!cycles.isEmpty()) {
            throw new CyclicDependencyException(cycles);
        }
        try {
            List vertices = this.sorter.reverseSort((DirectedGraph)dag);
            ArrayList<Contribution> ordered = new ArrayList<Contribution>(vertices.size());
            for (Vertex vertex : vertices) {
                ordered.add((Contribution)vertex.getEntity());
            }
            return ordered;
        }
        catch (GraphException e) {
            throw new DependencyException(e);
        }
    }

    @Override
    public List<Contribution> orderForUninstall(List<Contribution> contributions) {
        DirectedGraphImpl dag = new DirectedGraphImpl();
        for (Contribution contribution : contributions) {
            dag.add((Vertex)new VertexImpl((Object)contribution));
        }
        for (Vertex source : dag.getVertices()) {
            Contribution contribution = (Contribution)source.getEntity();
            URI uri = contribution.getUri();
            block4: for (ContributionWire wire : contribution.getWires()) {
                for (Contribution entry : contributions) {
                    if (!entry.getUri().equals(wire.getExportContributionUri())) continue;
                    Import imprt = wire.getImport();
                    List<Vertex<Contribution>> sinks = this.findTargetVertex((DirectedGraph<Contribution>)dag, uri, imprt);
                    if (sinks.isEmpty()) {
                        throw new AssertionError((Object)("Unable to resolve import " + imprt + " in " + uri));
                    }
                    for (Vertex<Contribution> sink : sinks) {
                        EdgeImpl edge = new EdgeImpl(source, sink);
                        dag.add((Edge)edge);
                    }
                    continue block4;
                }
            }
        }
        List cycles = this.detector.findCycles((DirectedGraph)dag);
        if (!cycles.isEmpty()) {
            throw new AssertionError((Object)"Cylces detected");
        }
        try {
            List vertices = this.sorter.sort((DirectedGraph)dag);
            ArrayList<Contribution> ordered = new ArrayList<Contribution>(vertices.size());
            for (Vertex vertex : vertices) {
                ordered.add((Contribution)vertex.getEntity());
            }
            return ordered;
        }
        catch (GraphException e) {
            throw new AssertionError((Object)e);
        }
    }

    private List<Vertex<Contribution>> findTargetVertex(DirectedGraph<Contribution> dag, URI contributionUri, Import imprt) {
        ArrayList<Vertex<Contribution>> vertices = new ArrayList<Vertex<Contribution>>();
        block0: for (Vertex vertex : dag.getVertices()) {
            Contribution contribution = (Contribution)vertex.getEntity();
            ContributionManifest manifest = contribution.getManifest();
            assert (manifest != null);
            URI location = imprt.getLocation();
            for (Export export : manifest.getExports()) {
                if (1 != export.match(imprt) || contributionUri.equals(contribution.getUri())) continue;
                if (location != null) {
                    if (!location.equals(contribution.getUri())) continue;
                    vertices.add((Vertex<Contribution>)vertex);
                    return vertices;
                }
                vertices.add((Vertex<Contribution>)vertex);
                if (imprt.isMultiplicity()) continue block0;
                return vertices;
            }
        }
        return vertices;
    }
}

