/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.contribution.ContributionResolutionException;
import org.fabric3.contribution.wire.ContributionWireInstantiatorRegistry;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.UnresolvedImportException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataStoreImpl
implements MetaDataStore {
    private Map<URI, Contribution> cache = new ConcurrentHashMap<URI, Contribution>();
    private Map<QName, Map<Export, List<Contribution>>> exportsToContributionCache = new ConcurrentHashMap<QName, Map<Export, List<Contribution>>>();
    private ProcessorRegistry processorRegistry;
    private ContributionWireInstantiatorRegistry instantiatorRegistry;

    public MetaDataStoreImpl(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setProcessorRegistry(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setInstantiatorRegistry(ContributionWireInstantiatorRegistry instantiatorRegistry) {
        this.instantiatorRegistry = instantiatorRegistry;
    }

    public void store(Contribution contribution) throws StoreException {
        this.cache.put(contribution.getUri(), contribution);
        this.addToExports(contribution);
    }

    public Contribution find(URI contributionUri) {
        return this.cache.get(contributionUri);
    }

    public Set<Contribution> getContributions() {
        return new HashSet<Contribution>(this.cache.values());
    }

    public void remove(URI contributionUri) {
        Contribution contribution = this.find(contributionUri);
        if (contribution != null) {
            List exports = contribution.getManifest().getExports();
            for (Export export : exports) {
                Map<Export, List<Contribution>> types = this.exportsToContributionCache.get(export.getType());
                if (types == null) {
                    throw new AssertionError((Object)("Export type not found: " + export.getType()));
                }
                Iterator<Map.Entry<Export, List<Contribution>>> it = types.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Export, List<Contribution>> contributions = it.next();
                    contributions.getValue().remove(contribution);
                    if (!contributions.getValue().isEmpty()) continue;
                    it.remove();
                }
            }
        }
        this.cache.remove(contributionUri);
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> find(Class<V> type, S symbol) {
        for (Contribution contribution : this.cache.values()) {
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement element : resource.getResourceElements()) {
                    if (!element.getSymbol().equals(symbol)) continue;
                    if (!resource.isProcessed()) {
                        throw new AssertionError((Object)"Attempt to resolve a resource before it is processed");
                    }
                    return element;
                }
            }
        }
        return null;
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> find(URI uri, Class<V> type, S symbol) throws StoreException {
        return this.resolve(uri, type, symbol, null);
    }

    public <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolve(URI uri, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new ContributionResolutionException("Contribution not found: " + identifier, identifier);
        }
        return this.resolve(contribution, type, symbol, context);
    }

    private <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolve(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        ResourceElement<S, V> element;
        for (ContributionWire wire : contribution.getWires()) {
            if (!wire.resolves(symbol)) continue;
            URI resolvedUri = wire.getExportContributionUri();
            Contribution resolved = this.cache.get(resolvedUri);
            if (resolved == null) {
                throw new AssertionError((Object)("Dependent contribution not found: " + resolvedUri));
            }
            element = this.resolve(resolved, type, symbol, context);
            if (element == null) continue;
            return element;
        }
        element = this.resolveInternal(contribution, type, symbol, context);
        if (element != null) {
            return element;
        }
        return null;
    }

    public List<Contribution> resolve(URI uri, Import imprt) {
        Map<Export, List<Contribution>> exports = this.exportsToContributionCache.get(imprt.getType());
        URI location = imprt.getLocation();
        ArrayList<Contribution> resolved = new ArrayList<Contribution>();
        if (exports != null) {
            for (Map.Entry<Export, List<Contribution>> entry : exports.entrySet()) {
                Export export = entry.getKey();
                if (1 != export.match(imprt)) continue;
                for (Contribution contribution : entry.getValue()) {
                    if (location != null) {
                        if (!location.equals(contribution.getUri())) continue;
                        resolved.add(contribution);
                        return resolved;
                    }
                    if (uri.equals(contribution.getUri())) continue;
                    resolved.add(contribution);
                }
            }
        }
        return resolved;
    }

    public List<ContributionWire<?, ?>> resolveContributionWires(URI uri, Import imprt) throws UnresolvedImportException {
        Map<Export, List<Contribution>> map = this.exportsToContributionCache.get(imprt.getType());
        if (map == null) {
            return null;
        }
        ArrayList wires = new ArrayList();
        for (Map.Entry<Export, List<Contribution>> entry : map.entrySet()) {
            Export export = entry.getKey();
            int level = export.match(imprt);
            if (level != 1) continue;
            if (this.instantiatorRegistry == null) {
                throw new AssertionError((Object)"Instantiator not yet configured");
            }
            for (Contribution contribution : entry.getValue()) {
                ContributionWire<Import, Export> wire;
                URI exportUri = contribution.getUri();
                URI location = imprt.getLocation();
                if (location != null && location.equals(exportUri)) {
                    wire = this.instantiatorRegistry.instantiate(imprt, export, uri, exportUri);
                    wires.add(wire);
                    return wires;
                }
                if (location != null) continue;
                wire = this.instantiatorRegistry.instantiate(imprt, export, uri, exportUri);
                wires.add(wire);
                if (imprt.isMultiplicity()) continue;
                return wires;
            }
        }
        if (wires.isEmpty()) {
            throw new UnresolvedImportException("Unable to resolve import: " + imprt);
        }
        return wires;
    }

    public Set<Contribution> resolveDependentContributions(URI uri) {
        HashSet<Contribution> dependents = new HashSet<Contribution>();
        block0: for (Contribution entry : this.cache.values()) {
            List contributionWires = entry.getWires();
            for (ContributionWire wire : contributionWires) {
                if (!uri.equals(wire.getExportContributionUri())) continue;
                dependents.add(entry);
                continue block0;
            }
        }
        return dependents;
    }

    public List<Contribution> resolveExtensionProviders(String name) {
        ArrayList<Contribution> providers = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extend : contribution.getManifest().getExtends()) {
                if (!extend.equals(name)) continue;
                providers.add(contribution);
                continue block0;
            }
        }
        return providers;
    }

    public List<Contribution> resolveExtensionPoints(String name) {
        ArrayList<Contribution> extensionPoints = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extensionPoint : contribution.getManifest().getExtensionPoints()) {
                if (!extensionPoint.equals(name)) continue;
                extensionPoints.add(contribution);
                continue block0;
            }
        }
        return extensionPoints;
    }

    public Set<Contribution> resolveCapabilities(Contribution contribution) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        return this.resolveCapabilities(contribution, extensions);
    }

    public Set<Contribution> resolveCapability(String capability) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        for (Contribution entry : this.cache.values()) {
            if (!entry.getManifest().getProvidedCapabilities().contains(capability) || extensions.contains(entry)) continue;
            extensions.add(entry);
            this.resolveCapabilities(entry, extensions);
        }
        return extensions;
    }

    private Set<Contribution> resolveCapabilities(Contribution contribution, Set<Contribution> extensions) {
        Set required = contribution.getManifest().getRequiredCapabilities();
        for (String capability : required) {
            for (Contribution entry : this.cache.values()) {
                if (!entry.getManifest().getProvidedCapabilities().contains(capability) || extensions.contains(entry)) continue;
                extensions.add(entry);
                this.resolveCapabilities(entry, extensions);
            }
        }
        for (ContributionWire wire : contribution.getWires()) {
            Contribution imported = this.cache.get(wire.getExportContributionUri());
            if (imported.getManifest().isExtension() && !extensions.contains(imported) && !imported.getUri().equals(Names.HOST_CONTRIBUTION) && !imported.getUri().equals(Names.BOOT_CONTRIBUTION)) {
                extensions.add(imported);
            }
            this.resolveCapabilities(imported, extensions);
        }
        for (URI uri : contribution.getResolvedExtensionProviders()) {
            Contribution provider = this.cache.get(uri);
            if (extensions.contains(provider)) continue;
            extensions.add(provider);
        }
        return extensions;
    }

    private <S extends Symbol, V extends Serializable> ResourceElement<S, V> resolveInternal(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) throws StoreException {
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement element : resource.getResourceElements()) {
                Object val;
                if (!element.getSymbol().equals(symbol)) continue;
                if (!resource.isProcessed() && context == null) {
                    String identifier = resource.getSource().getSystemId();
                    throw new AssertionError((Object)("Resource not resolved: " + identifier));
                }
                if (!resource.isProcessed() && context != null) {
                    try {
                        this.processorRegistry.processResource(resource, context);
                    }
                    catch (ContributionException e) {
                        String identifier = resource.getSource().getSystemId();
                        throw new StoreException("Error resolving resource: " + identifier, (Throwable)e);
                    }
                }
                if (!type.isInstance(val = element.getValue())) {
                    throw new IllegalArgumentException("Invalid type for symbol. Expected: " + type + " was: " + val);
                }
                return element;
            }
        }
        return null;
    }

    private void addToExports(Contribution contribution) {
        List exports = contribution.getManifest().getExports();
        if (exports.size() > 0) {
            for (Export export : exports) {
                List<Contribution> contributions;
                Map<Export, List<Contribution>> map = this.exportsToContributionCache.get(export.getType());
                if (map == null) {
                    map = new ConcurrentHashMap<Export, List<Contribution>>();
                    this.exportsToContributionCache.put(export.getType(), map);
                    contributions = new ArrayList<Contribution>();
                    contributions.add(contribution);
                    map.put(export, contributions);
                    continue;
                }
                contributions = map.get(export);
                if (contributions == null) {
                    contributions = new ArrayList<Contribution>();
                    map.put(export, contributions);
                }
                contributions.add(contribution);
            }
        }
    }
}

