/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.contribution.UnsupportedContentTypeException;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionProcessor;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.osoa.sca.annotations.EagerInit;

@EagerInit
public class ProcessorRegistryImpl
implements ProcessorRegistry {
    private Map<String, ContributionProcessor> contributionProcessorCache = new HashMap<String, ContributionProcessor>();
    private Map<String, ResourceProcessor> resourceProcessorCache = new HashMap<String, ResourceProcessor>();

    public void register(ContributionProcessor processor) {
        for (String contentType : processor.getContentTypes()) {
            this.contributionProcessorCache.put(contentType, processor);
        }
    }

    public void unregisterContributionProcessor(String contentType) {
        this.contributionProcessorCache.remove(contentType);
    }

    public void register(ResourceProcessor processor) {
        this.resourceProcessorCache.put(processor.getContentType(), processor);
    }

    public void unregisterResourceProcessor(String contentType) {
        this.resourceProcessorCache.remove(contentType);
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        String contentType = contribution.getContentType();
        ContributionProcessor processor = this.contributionProcessorCache.get(contentType);
        if (processor == null) {
            String source = contribution.getUri().toString();
            throw new UnsupportedContentTypeException("Type " + contentType + " in contribution " + source + " not supported", contentType);
        }
        processor.processManifest(contribution, context);
    }

    public void indexContribution(Contribution contribution, IntrospectionContext context) throws InstallException {
        String contentType = contribution.getContentType();
        ContributionProcessor processor = this.contributionProcessorCache.get(contentType);
        if (processor == null) {
            String source = contribution.getUri().toString();
            throw new UnsupportedContentTypeException("Type " + contentType + "in contribution " + source + " not supported", contentType);
        }
        processor.index(contribution, context);
    }

    public void indexResource(Contribution contribution, String contentType, Source source, IntrospectionContext context) throws InstallException {
        ResourceProcessor processor = this.resourceProcessorCache.get(contentType);
        if (processor == null) {
            return;
        }
        processor.index(contribution, source, context);
    }

    public void processContribution(Contribution contribution, IntrospectionContext context) throws InstallException {
        String contentType = contribution.getContentType();
        ContributionProcessor processor = this.contributionProcessorCache.get(contentType);
        if (processor == null) {
            String source = contribution.getUri().toString();
            throw new UnsupportedContentTypeException("Type " + contentType + "in contribution " + source + " not supported", contentType);
        }
        processor.process(contribution, context);
    }

    public void processResource(Resource resource, IntrospectionContext context) throws InstallException {
        ResourceProcessor processor = this.resourceProcessorCache.get(resource.getContentType());
        if (processor == null) {
            return;
        }
        processor.process(resource, context);
    }
}

