/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.contribution.UnsupportedContentTypeException;
import org.fabric3.contribution.archive.AbstractContributionProcessor;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.archive.Action;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveContributionProcessor
extends AbstractContributionProcessor {
    private static final List<String> CONTENT_TYPES = ArchiveContributionProcessor.initializeContentTypes();
    private List<ArchiveContributionHandler> handlers;

    @Reference
    public void setHandlers(List<ArchiveContributionHandler> handlers) {
        this.handlers = handlers;
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            CONTENT_TYPES.add(handlers.get(i).getContentType());
        }
    }

    public List<String> getContentTypes() {
        return CONTENT_TYPES;
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        handler.processManifest(contribution, context);
    }

    public void index(Contribution contribution, final IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        handler.iterateArtifacts(contribution, new Action(){

            public void process(Contribution contribution, String contentType, URL url) throws InstallException {
                UrlSource source = new UrlSource(url);
                ArchiveContributionProcessor.this.registry.indexResource(contribution, contentType, (Source)source, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Contribution contribution, IntrospectionContext context) throws InstallException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            for (Resource resource : contribution.getResources()) {
                if (resource.isProcessed()) continue;
                this.registry.processResource(resource, context);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private ArchiveContributionHandler getHandler(Contribution contribution) throws UnsupportedContentTypeException {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return handler;
        }
        String source = contribution.getUri().toString();
        throw new UnsupportedContentTypeException("Contribution type not supported: " + source, source);
    }

    private static List<String> initializeContentTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("application/octet-stream");
        return list;
    }
}

