/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.host.util.FileHelper;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.archive.Action;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.osoa.sca.annotations.Reference;

public class ExplodedArchiveContributionHandler
implements ArchiveContributionHandler {
    private Loader loader;
    private final ContentTypeResolver contentTypeResolver;

    public ExplodedArchiveContributionHandler(@Reference Loader loader, @Reference ContentTypeResolver contentTypeResolver) {
        this.loader = loader;
        this.contentTypeResolver = contentTypeResolver;
    }

    public String getContentType() {
        return "application/vnd.fabric3.folder";
    }

    public boolean canProcess(Contribution contribution) {
        return "application/vnd.fabric3.folder".equals(contribution.getContentType());
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        try {
            URL sourceUrl = contribution.getLocation();
            URL manifestUrl = new URL(sourceUrl.toString() + "/META-INF/sca-contribution.xml");
            ClassLoader cl = this.getClass().getClassLoader();
            URI uri = contribution.getUri();
            DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(uri, cl);
            UrlSource source = new UrlSource(manifestUrl);
            ContributionManifest manifest = (ContributionManifest)this.loader.load((Source)source, ContributionManifest.class, (IntrospectionContext)childContext);
            if (childContext.hasErrors()) {
                context.addErrors(childContext.getErrors());
            }
            if (childContext.hasWarnings()) {
                context.addWarnings(childContext.getWarnings());
            }
            contribution.setManifest(manifest);
        }
        catch (LoaderException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw new InstallException((Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public void iterateArtifacts(Contribution contribution, Action action) throws InstallException {
        File root = FileHelper.toFile((URL)contribution.getLocation());
        assert (root.isDirectory());
        this.iterateArtifactsResursive(contribution, action, root);
    }

    protected void iterateArtifactsResursive(Contribution contribution, Action action, File dir) throws InstallException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.iterateArtifactsResursive(contribution, action, file);
                continue;
            }
            try {
                URL entryUrl = file.toURI().toURL();
                String contentType = this.contentTypeResolver.getContentType(entryUrl);
                if (contentType == null) continue;
                action.process(contribution, contentType, entryUrl);
            }
            catch (MalformedURLException e) {
                throw new InstallException((Throwable)e);
            }
            catch (IOException e) {
                throw new InstallException((Throwable)e);
            }
            catch (ContentTypeResolutionException e) {
                throw new InstallException((Throwable)e);
            }
        }
    }
}

