/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.util.IOHelper;
import org.fabric3.spi.contribution.archive.ClasspathProcessor;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.oasisopen.sca.annotation.Property;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JarClasspathProcessor
implements ClasspathProcessor {
    private ClasspathProcessorRegistry registry;
    private HostInfo hostInfo;
    private boolean explodeJars;

    public JarClasspathProcessor(@Reference ClasspathProcessorRegistry registry, @Reference HostInfo hostInfo) {
        this.registry = registry;
        this.hostInfo = hostInfo;
    }

    @Property(required=false)
    public void setExplodeJars(boolean explodeJars) {
        this.explodeJars = explodeJars;
    }

    @Init
    public void init() {
        this.registry.register((ClasspathProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister((ClasspathProcessor)this);
    }

    public boolean canProcess(URL url) {
        String name = url.getFile().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    public List<URL> process(URL url) throws IOException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        classpath.add(url);
        this.addLibraries(classpath, url);
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraries(List<URL> classpath, URL jar) throws IOException {
        File dir = this.hostInfo.getTempDir();
        InputStream is = jar.openStream();
        try {
            JarEntry entry;
            JarInputStream jarStream = new JarInputStream(is);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String path;
                if (entry.isDirectory() || !(path = entry.getName()).startsWith("META-INF/lib/")) continue;
                if (this.explodeJars) {
                    String fileName = path.substring(path.lastIndexOf(47));
                    File explodedDirectory = new File(dir, fileName);
                    this.explodeJar(dir, jarStream, explodedDirectory);
                    classpath.add(explodedDirectory.toURI().toURL());
                    continue;
                }
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File jarFile = File.createTempFile("fabric3", ".jar", dir);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
                try {
                    IOHelper.copy((InputStream)jarStream, (OutputStream)os);
                    ((OutputStream)os).flush();
                }
                finally {
                    ((OutputStream)os).close();
                }
                jarFile.deleteOnExit();
                classpath.add(jarFile.toURI().toURL());
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explodeJar(File dir, JarInputStream jarStream, File explodedDirectory) throws IOException, FileNotFoundException {
        if (!explodedDirectory.exists()) {
            explodedDirectory.mkdirs();
            File jarFile = File.createTempFile("fabric3", ".jar", dir);
            jarFile.createNewFile();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile));
            try {
                IOHelper.copy((InputStream)jarStream, (OutputStream)os);
                ((OutputStream)os).flush();
            }
            finally {
                ((OutputStream)os).close();
            }
            try {
                JarEntry entry;
                FileInputStream inputStream = new FileInputStream(jarFile);
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                while ((entry = jarInputStream.getNextJarEntry()) != null) {
                    String filePath = entry.getName();
                    if (entry.isDirectory()) continue;
                    File entryFile = new File(explodedDirectory, filePath);
                    entryFile.getParentFile().mkdirs();
                    entryFile.createNewFile();
                    BufferedOutputStream entryOutputStream = new BufferedOutputStream(new FileOutputStream(entryFile));
                    IOHelper.copy((InputStream)jarInputStream, (OutputStream)entryOutputStream);
                    ((OutputStream)entryOutputStream).flush();
                    ((OutputStream)entryOutputStream).close();
                }
                inputStream.close();
            }
            finally {
                jarFile.delete();
            }
        }
    }
}

