/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.manifest.ExtendsDeclaration;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.contribution.manifest.ProvidesDeclaration;
import org.fabric3.host.Constants;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.contribution.Deployable;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ContributionElementLoader
implements TypeLoader<ContributionManifest> {
    private static final QName CONTRIBUTION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "contribution");
    private static final QName DEPLOYABLE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "deployable");
    private final LoaderRegistry registry;

    public ContributionElementLoader(@Reference LoaderRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void start() {
        this.registry.registerLoader(CONTRIBUTION, (TypeLoader)this);
    }

    @Destroy
    public void stop() {
        this.registry.unregisterLoader(CONTRIBUTION);
    }

    public ContributionManifest load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ContributionManifest manifest = new ContributionManifest();
        QName element = reader.getName();
        if (!CONTRIBUTION.equals(element)) {
            throw new AssertionError((Object)("Loader not positioned on the <contribution> element: " + element));
        }
        this.validateContributionAttributes(reader, context);
        boolean extension = Boolean.valueOf(reader.getAttributeValue("urn:fabric3.org:core", "extension"));
        manifest.setExtension(extension);
        String description = reader.getAttributeValue("urn:fabric3.org:core", "description");
        manifest.setDescription(description);
        this.parseCapabilities(reader, manifest);
        block6: while (true) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    Object declaration;
                    Object o;
                    MissingManifestAttribute failure;
                    element = reader.getName();
                    if (DEPLOYABLE.equals(element)) {
                        QName qName;
                        this.validateDeployableAttributes(reader, context);
                        String name = reader.getAttributeValue(null, "composite");
                        if (name == null) {
                            failure = new MissingManifestAttribute("Composite attribute must be specified", reader);
                            context.addError((ValidationFailure)failure);
                            return null;
                        }
                        int index = name.indexOf(58);
                        if (index != -1) {
                            String prefix = name.substring(0, index);
                            String localPart = name.substring(index + 1);
                            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
                            if (ns == null) {
                                URI uri = context.getContributionUri();
                                context.addError((ValidationFailure)new InvalidQNamePrefix("The prefix " + prefix + " specified in the contribution manifest file for " + uri + " is invalid", reader));
                                return null;
                            }
                            qName = new QName(ns, localPart, prefix);
                        } else {
                            qName = new QName(null, name);
                        }
                        List<RuntimeMode> runtimeModes = this.parseRuntimeModes(reader, context);
                        Deployable deployable = new Deployable(qName, Constants.COMPOSITE_TYPE, runtimeModes);
                        manifest.addDeployable(deployable);
                        break;
                    }
                    try {
                        o = this.registry.load(reader, Object.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure2 = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure2);
                        return null;
                    }
                    if (o instanceof Export) {
                        manifest.addExport((Export)o);
                        break;
                    }
                    if (o instanceof Import) {
                        manifest.addImport((Import)o);
                        break;
                    }
                    if (o instanceof ExtendsDeclaration) {
                        declaration = (ExtendsDeclaration)o;
                        manifest.addExtend(((ExtendsDeclaration)declaration).getName());
                        break;
                    }
                    if (o instanceof ProvidesDeclaration) {
                        declaration = (ProvidesDeclaration)o;
                        manifest.addExtensionPoint(((ProvidesDeclaration)declaration).getName());
                        break;
                    }
                    if (o == null) continue block6;
                    failure = new UnrecognizedElement(reader);
                    context.addError((ValidationFailure)failure);
                    return null;
                }
                case 2: {
                    if (!CONTRIBUTION.equals(reader.getName())) break;
                    return manifest;
                }
            }
        }
    }

    private void parseCapabilities(XMLStreamReader reader, ContributionManifest manifest) {
        String providesAttr;
        String requiresAttr = reader.getAttributeValue("urn:fabric3.org:core", "required-capabilities");
        if (requiresAttr != null) {
            String[] requires;
            for (String require : requires = requiresAttr.trim().split(" ")) {
                manifest.addRequiredCapability(require);
            }
        }
        if ((providesAttr = reader.getAttributeValue("urn:fabric3.org:core", "capabilities")) != null) {
            String[] provides;
            for (String provide : provides = providesAttr.trim().split(" ")) {
                manifest.addProvidedCapability(provide);
            }
        }
    }

    private List<RuntimeMode> parseRuntimeModes(XMLStreamReader reader, IntrospectionContext context) {
        List<Object> runtimeModes;
        String modeAttr = reader.getAttributeValue(null, "modes");
        if (modeAttr == null) {
            runtimeModes = Deployable.DEFAULT_MODES;
        } else {
            String[] modes = modeAttr.trim().split(" ");
            runtimeModes = new ArrayList<RuntimeMode>();
            for (String mode : modes) {
                if ("controller".equals(mode)) {
                    runtimeModes.add(RuntimeMode.CONTROLLER);
                    continue;
                }
                if ("participant".equals(mode)) {
                    runtimeModes.add(RuntimeMode.PARTICIPANT);
                    continue;
                }
                if ("vm".equals(mode)) {
                    runtimeModes.add(RuntimeMode.VM);
                    continue;
                }
                runtimeModes = Deployable.DEFAULT_MODES;
                InvalidValue error = new InvalidValue("Invalid mode attribute: " + modeAttr, reader);
                context.addError((ValidationFailure)error);
                break;
            }
        }
        return runtimeModes;
    }

    private void validateContributionAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("extension".equals(name) || "description".equals(name) || "capabilities".equals(name) || "required-capabilities".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }

    private void validateDeployableAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("composite".equals(name) || "modes".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

