/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.manifest.MissingPackage;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.contribution.manifest.PackageVersion;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.osoa.sca.annotations.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaExportLoader
implements TypeLoader<JavaExport> {
    public JavaExport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        PackageInfo info;
        String statement = reader.getAttributeValue(null, "package");
        if (statement == null) {
            MissingPackage failure = new MissingPackage("No package name specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String version = reader.getAttributeValue(null, "version");
        if (version != null) {
            PackageVersion packageVersion;
            try {
                packageVersion = new PackageVersion(version);
            }
            catch (IllegalArgumentException e) {
                context.addError((ValidationFailure)new InvalidValue("Invalid export version", reader, (Throwable)e));
                packageVersion = new PackageVersion("0");
            }
            info = new PackageInfo(statement, packageVersion, true, true);
        } else {
            info = new PackageInfo(statement);
        }
        return new JavaExport(info);
    }
}

