/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.contribution.manifest.QNameExport;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class QNameExportLoader
implements TypeLoader<QNameExport> {
    public QNameExport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String ns = reader.getAttributeValue(null, "namespace");
        if (ns == null) {
            MissingManifestAttribute failure = new MissingManifestAttribute("The namespace attribute must be specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        return new QNameExport(ns);
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("namespace".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

