/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.stream.Source;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.xml.XmlIndexerRegistry;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoaderRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.xml.XMLFactory;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class XmlResourceProcessor
implements ResourceProcessor {
    private ProcessorRegistry processorRegistry;
    private XmlResourceElementLoaderRegistry elementLoaderRegistry;
    private XmlIndexerRegistry indexerRegistry;
    private XMLInputFactory xmlFactory;

    public XmlResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference XmlIndexerRegistry indexerRegistry, @Reference XmlResourceElementLoaderRegistry elementLoaderRegistry, @Reference XMLFactory xmlFactory) {
        this.processorRegistry = processorRegistry;
        this.elementLoaderRegistry = elementLoaderRegistry;
        this.indexerRegistry = indexerRegistry;
        this.xmlFactory = xmlFactory.newInputFactoryInstance();
    }

    @Init
    public void init() {
        this.processorRegistry.register((ResourceProcessor)this);
    }

    public String getContentType() {
        return "application/xml";
    }

    public void index(Contribution contribution, Source source, IntrospectionContext context) throws InstallException {
        XMLStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = source.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            if (this.skipToFirstTag(reader)) {
                return;
            }
            Resource resource = new Resource(source, "application/xml");
            this.indexerRegistry.index(resource, reader, context);
            contribution.addResource(resource);
        }
        catch (XMLStreamException e) {
            throw new InstallException((Throwable)e);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
        InputStream stream = null;
        XMLStreamReader reader = null;
        try {
            stream = resource.getSource().openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            if (this.skipToFirstTag(reader)) {
                resource.setProcessed(true);
                return;
            }
            this.elementLoaderRegistry.load(reader, resource, context);
            resource.setProcessed(true);
        }
        catch (XMLStreamException e) {
            throw new InstallException((Throwable)e);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean skipToFirstTag(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && 1 != reader.getEventType()) {
            reader.next();
        }
        return 8 == reader.getEventType();
    }
}

