/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.resource.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.annotation.Resource;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.resource.model.SystemSourcedResourceReference;
import org.fabric3.resource.spi.ResourceTypeHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Resource, I> {
    private IntrospectionHelper helper;
    private JavaContractProcessor contractProcessor;
    private Map<Class<?>, ResourceTypeHandler> handlers = new HashMap();

    public ResourceProcessor(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor) {
        super(Resource.class);
        this.helper = helper;
        this.contractProcessor = contractProcessor;
    }

    @Reference(required=false)
    public void setHandlers(Map<Class<?>, ResourceTypeHandler> handlers) {
        this.handlers = handlers;
    }

    public void visitConstructorParameter(Resource annotation, Constructor<?> constructor, int index, Class<?> implClass, I implementation, IntrospectionContext context) {
        ResourceReferenceDefinition definition;
        String name = this.helper.getSiteName(constructor, index, annotation.name());
        Type genericType = this.helper.getGenericType(constructor, index);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        ResourceTypeHandler handler = this.handlers.get(type);
        if (handler != null) {
            definition = handler.createResourceReference(name, annotation, constructor, context);
        } else {
            boolean optional = annotation.optional();
            String mappedName = annotation.mappedName();
            if (mappedName.length() == 0) {
                mappedName = type.getSimpleName();
            }
            definition = this.createResource(name, type, optional, mappedName, context);
        }
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }

    public void visitField(Resource annotation, Field field, Class<?> implClass, I implementation, IntrospectionContext context) {
        ResourceReferenceDefinition definition;
        String name = this.helper.getSiteName(field, annotation.name());
        Type genericType = field.getGenericType();
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        FieldInjectionSite site = new FieldInjectionSite(field);
        ResourceTypeHandler handler = this.handlers.get(type);
        if (handler != null) {
            definition = handler.createResourceReference(name, annotation, field, context);
        } else {
            boolean optional = annotation.optional();
            String mappedName = annotation.mappedName();
            if (mappedName.length() == 0) {
                mappedName = type.getSimpleName();
            }
            definition = this.createResource(name, type, optional, mappedName, context);
        }
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }

    public void visitMethod(Resource annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        ResourceReferenceDefinition definition;
        String name = this.helper.getSiteName(method, annotation.name());
        Type genericType = this.helper.getGenericType(method);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class type = this.helper.getBaseType(genericType, typeMapping);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        ResourceTypeHandler handler = this.handlers.get(type);
        if (handler != null) {
            definition = handler.createResourceReference(name, annotation, method, context);
        } else {
            boolean optional = annotation.optional();
            String mappedName = annotation.mappedName();
            if (mappedName.length() == 0) {
                mappedName = type.getSimpleName();
            }
            definition = this.createResource(name, type, optional, mappedName, context);
        }
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }

    private SystemSourcedResourceReference createResource(String name, Class<?> type, boolean optional, String mappedName, IntrospectionContext context) {
        JavaServiceContract serviceContract = this.contractProcessor.introspect(type, context);
        return new SystemSourcedResourceReference(name, optional, mappedName, (ServiceContract)serviceContract);
    }
}

