/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.binding.format;

import org.fabric3.spi.binding.format.EncodeCallback;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.binding.format.HeaderContext;
import org.fabric3.spi.binding.format.MessageEncoder;
import org.fabric3.spi.binding.format.ResponseEncodeCallback;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMessageEncoder
implements MessageEncoder {
    @Override
    public String encodeText(String operationName, Message message, EncodeCallback callback) throws EncoderException {
        return Base64.encode(this.encode(message));
    }

    @Override
    public byte[] encodeBytes(String operationName, Message message, EncodeCallback callback) throws EncoderException {
        return this.encode(message);
    }

    @Override
    public String encodeResponseText(String operationName, Message message, ResponseEncodeCallback callback) throws EncoderException {
        String serialized = Base64.encode(this.encode(message));
        callback.encodeContentLengthHeader(serialized.length());
        return serialized;
    }

    @Override
    public byte[] encodeResponseBytes(String operationName, Message message, ResponseEncodeCallback callback) throws EncoderException {
        byte[] serialized = this.encode(message);
        callback.encodeContentLengthHeader(serialized.length);
        return serialized;
    }

    @Override
    public Message decodeResponse(byte[] serialized) throws EncoderException {
        return this.decode(Message.class, serialized);
    }

    @Override
    public Message decodeResponse(String serialized) throws EncoderException {
        return this.decode(Message.class, Base64.decode(serialized));
    }

    @Override
    public Message decodeFault(byte[] serialized) throws EncoderException {
        return this.decode(Message.class, serialized);
    }

    @Override
    public Message decodeFault(String serialized) throws EncoderException {
        return this.decode(Message.class, Base64.decode(serialized));
    }

    @Override
    public Message decode(byte[] serialized, HeaderContext context) throws EncoderException {
        return this.decode(Message.class, serialized);
    }

    @Override
    public Message decode(String serialized, HeaderContext context) throws EncoderException {
        return this.decode(Message.class, Base64.decode(serialized));
    }

    protected abstract byte[] encode(Object var1) throws EncoderException;

    protected abstract <T> T decode(Class<T> var1, byte[] var2) throws EncoderException;
}

