/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.binding.format;

import org.fabric3.spi.binding.format.AbstractParameterEncoder;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseParameterEncoder
extends AbstractParameterEncoder {
    private ClassLoader loader;

    protected BaseParameterEncoder(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public byte[] encodeBytes(Message message) throws EncoderException {
        Object body = message.getBody();
        if (body != null && body.getClass().isArray() && !body.getClass().getComponentType().isPrimitive()) {
            Object[] array = (Object[])body;
            if (array.length == 1) {
                body = array[0];
            } else if (array.length > 1) {
                throw new UnsupportedOperationException("Multiple paramters not supported");
            }
        }
        return this.serialize(body);
    }

    @Override
    public String encodeText(Message message) throws EncoderException {
        return Base64.encode(this.encodeBytes(message));
    }

    @Override
    public Object decode(String operationName, String body) throws EncoderException {
        return this.deserialize(Object.class, Base64.decode(body), this.loader);
    }

    @Override
    public Object decode(String operationName, byte[] serialized) throws EncoderException {
        return this.deserialize(Object.class, serialized, this.loader);
    }

    @Override
    public Object decodeResponse(String operationName, String serialized) throws EncoderException {
        return this.deserialize(Object.class, Base64.decode(serialized), this.loader);
    }

    @Override
    public Object decodeResponse(String operationName, byte[] serialized) throws EncoderException {
        return this.deserialize(Object.class, serialized, this.loader);
    }

    @Override
    public Throwable decodeFault(String operationName, byte[] body) throws EncoderException {
        return this.deserialize(Throwable.class, body, this.loader);
    }

    @Override
    public Throwable decodeFault(String operationName, String serialized) throws EncoderException {
        return this.decodeFault(operationName, Base64.decode(serialized));
    }

    protected abstract byte[] serialize(Object var1) throws EncoderException;

    protected abstract <T> T deserialize(Class<T> var1, byte[] var2, ClassLoader var3) throws EncoderException;
}

