/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.binding.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.fabric3.spi.binding.format.EncodeCallback;
import org.fabric3.spi.binding.format.EncoderException;
import org.fabric3.spi.binding.format.HeaderContext;
import org.fabric3.spi.binding.format.MessageEncoder;
import org.fabric3.spi.binding.format.ResponseEncodeCallback;
import org.fabric3.spi.binding.format.UnsupportedTypesException;
import org.fabric3.spi.classloader.ClassLoaderObjectInputStream;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.MessageImpl;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKUnwrappedMessageEncoder
implements MessageEncoder {
    @Override
    public String encodeText(String operationName, Message message, EncodeCallback callback) throws EncoderException {
        callback.encodeOperationHeader(operationName);
        String routing = Base64.encode(this.serialize(message.getWorkContext().getCallFrameStack()));
        callback.encodeRoutingHeader(routing);
        if (!(message.getBody() instanceof String)) {
            throw new UnsupportedOperationException("Message body must be serialized as a String");
        }
        String body = (String)message.getBody();
        callback.encodeContentLengthHeader(body.length());
        return body;
    }

    @Override
    public byte[] encodeBytes(String operationName, Message message, EncodeCallback callback) throws EncoderException {
        callback.encodeOperationHeader(operationName);
        String routing = Base64.encode(this.serialize(message.getWorkContext().getCallFrameStack()));
        callback.encodeRoutingHeader(routing);
        if (!(message.getBody() instanceof byte[])) {
            throw new UnsupportedOperationException("Message body must be serialized as a byte[]");
        }
        byte[] body = (byte[])message.getBody();
        callback.encodeContentLengthHeader(body.length);
        return body;
    }

    @Override
    public String encodeResponseText(String operationName, Message message, ResponseEncodeCallback callback) throws EncoderException {
        if (!(message.getBody() instanceof String)) {
            throw new UnsupportedOperationException("Message body must be serialized as a String");
        }
        String body = (String)message.getBody();
        callback.encodeContentLengthHeader(body.length());
        return body;
    }

    @Override
    public byte[] encodeResponseBytes(String operationName, Message message, ResponseEncodeCallback callback) throws EncoderException {
        if (!(message.getBody() instanceof byte[])) {
            throw new UnsupportedOperationException("Message body must be serialized as a byte[]");
        }
        byte[] body = (byte[])message.getBody();
        callback.encodeContentLengthHeader(body.length);
        return body;
    }

    @Override
    public Message decode(byte[] serialized, HeaderContext context) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBody(serialized);
        List frames = this.deserialize(List.class, context.getRoutingBytes());
        workContext.addCallFrames(frames);
        return message;
    }

    @Override
    public Message decode(String serialized, HeaderContext context) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBody(serialized);
        List frames = this.deserialize(List.class, Base64.decode(context.getRoutingText()));
        workContext.addCallFrames(frames);
        return message;
    }

    @Override
    public Message decodeResponse(byte[] serialized) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBody(serialized);
        return message;
    }

    @Override
    public Message decodeResponse(String serialized) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBody(serialized);
        return message;
    }

    @Override
    public Message decodeFault(byte[] serialized) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBodyWithFault(serialized);
        return message;
    }

    @Override
    public Message decodeFault(String serialized) throws EncoderException {
        MessageImpl message = new MessageImpl();
        WorkContext workContext = new WorkContext();
        message.setWorkContext(workContext);
        message.setBodyWithFault(serialized);
        return message;
    }

    private byte[] serialize(Object o) throws EncoderException {
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bos);
            stream.writeObject(o);
            stream.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> T deserialize(Class<T> clazz, Object object) throws EncoderException {
        ByteArrayInputStream bis = null;
        ObjectInputStream stream = null;
        try {
            boolean isString = String.class.equals(clazz);
            if (!Byte.TYPE.equals(object.getClass().getComponentType()) && isString) {
                throw new UnsupportedTypesException("This implementation only supports serialization from bytes or Strings");
            }
            byte[] bytes = isString ? Base64.decode((String)object) : (byte[])object;
            bis = new ByteArrayInputStream(bytes);
            stream = new ClassLoaderObjectInputStream(bis, this.getClass().getClassLoader());
            T t = clazz.cast(stream.readObject());
            return t;
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        catch (ClassNotFoundException e) {
            throw new EncoderException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

