/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.classloader;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.fabric3.spi.classloader.MultiParentClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringMultiparentClassLoader
extends MultiParentClassLoader {
    private Set<Pattern> patterns = new HashSet<Pattern>();

    public FilteringMultiparentClassLoader(URI name, ClassLoader parent, Set<String> filters) {
        super(name, parent);
        this.compile(filters);
    }

    public FilteringMultiparentClassLoader(URI name, URL[] urls, ClassLoader parent, Set<String> filters) {
        super(name, urls, parent);
        this.compile(filters);
    }

    public Set<Pattern> getPatterns() {
        return this.patterns;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            boolean found = false;
            for (Pattern pattern : this.patterns) {
                String replacedName;
                if (!pattern.matcher(replacedName = name.replace(".", "\\.")).matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                clazz = this.findClass(name);
            }
            if (clazz == null) {
                clazz = super.loadClass(name, resolve);
                return clazz;
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private void compile(Set<String> filters) {
        for (String filter : filters) {
            String replacedFilter = filter.replace(".", "..");
            Pattern p = Pattern.compile(replacedFilter);
            this.patterns.add(p);
        }
    }
}

