/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.classloader;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends URLClassLoader {
    private static final URL[] NOURLS = new URL[0];
    private final URI name;
    private final List<ClassLoader> parents = new CopyOnWriteArrayList<ClassLoader>();
    private final List<MultiParentClassLoader> extensions = new CopyOnWriteArrayList<MultiParentClassLoader>();

    public MultiParentClassLoader(URI name, ClassLoader parent) {
        this(name, NOURLS, parent);
    }

    public MultiParentClassLoader(URI name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (parent == null) {
            throw new IllegalArgumentException("Parent classloader cannot be null");
        }
        this.name = name;
    }

    @Override
    public void addURL(URL url) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        super.addURL(url);
    }

    public void addParent(ClassLoader parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        if (parent != null) {
            this.parents.add(parent);
        }
    }

    public URI getName() {
        return this.name;
    }

    public List<ClassLoader> getParents() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        ArrayList<ClassLoader> list = new ArrayList<ClassLoader>();
        if (this.getParent() != null) {
            list.add(this.getParent());
        }
        list.addAll(this.parents);
        return list;
    }

    public void addExtensionClassLoader(MultiParentClassLoader classloader) {
        this.extensions.add(classloader);
    }

    public void removeExtensionClassLoader(MultiParentClassLoader classloader) {
        this.extensions.remove(classloader);
    }

    public URL findExtensionResource(String name) {
        return super.findResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block16: {
            clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    try {
                        clazz = Class.forName(name, resolve, this.getParent());
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        for (ClassLoader parent : this.parents) {
                            try {
                                clazz = parent.loadClass(name);
                                break;
                            }
                            catch (ClassNotFoundException e) {
                            }
                        }
                    }
                    if (clazz != null) break block16;
                    try {
                        clazz = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        for (MultiParentClassLoader extension : this.extensions) {
                            clazz = extension.findLoadedClass(name);
                            if (clazz == null) {
                                clazz = extension.findClass(name);
                            }
                            if (clazz == null) continue;
                            break;
                        }
                        if (clazz == null) {
                            throw e;
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader parent : this.parents) {
            URL resource = parent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        URL resource = super.findResource(name);
        if (resource == null) {
            for (MultiParentClassLoader extension : this.extensions) {
                resource = extension.findExtensionResource(name);
                if (resource == null) continue;
                return resource;
            }
        }
        return resource;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader parent : this.parents) {
            Enumeration<URL> parentResources = parent.getResources(name);
            while (parentResources.hasMoreElements()) {
                resources.add(parentResources.nextElement());
            }
        }
        Enumeration<URL> myResources = super.findResources(name);
        while (myResources.hasMoreElements()) {
            resources.add(myResources.nextElement());
        }
        return Collections.enumeration(resources);
    }

    public String toString() {
        return this.name.toString();
    }
}

