/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution.manifest;

import org.fabric3.spi.contribution.manifest.PackageVersion;

public final class PackageInfo {
    private static final PackageVersion NON_SPECIFIED = new PackageVersion(0, 0, 0);
    private String name;
    private PackageVersion minVersion = NON_SPECIFIED;
    private PackageVersion maxVersion;
    private boolean required;
    private String[] packageNames;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;

    public PackageInfo(String name, PackageVersion minVersion, boolean minInclusive, PackageVersion maxVersion, boolean maxInclusive, boolean required) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.setName(name);
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.required = required;
    }

    public PackageInfo(String name, PackageVersion version, boolean minInclusive, boolean required) {
        this.setName(name);
        this.minVersion = version;
        this.minInclusive = minInclusive;
        this.required = required;
    }

    public PackageInfo(String name) {
        this.setName(name);
        this.required = true;
    }

    public PackageInfo(String name, PackageVersion version) {
        this.setName(name);
        this.minVersion = version;
    }

    public PackageInfo(String name, boolean required) {
        this.setName(name);
        this.required = required;
    }

    public PackageInfo() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.packageNames = name.split("\\.");
    }

    public PackageVersion getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(PackageVersion minVersion) {
        this.minVersion = minVersion;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    public PackageVersion getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(PackageVersion maxVersion) {
        this.maxVersion = maxVersion;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean matches(PackageInfo exportPackage) {
        int i = 0;
        if (this.packageNames.length < exportPackage.packageNames.length && !"*".equals(this.packageNames[this.packageNames.length - 1])) {
            return false;
        }
        for (String packageName : exportPackage.packageNames) {
            if ("*".equals(packageName)) break;
            if (this.packageNames.length - 1 >= i && !packageName.equals(this.packageNames[i])) {
                return false;
            }
            if (this.packageNames.length - 1 != ++i || this.packageNames.length <= exportPackage.packageNames.length || "*".equals(this.packageNames[i])) continue;
            return false;
        }
        if (this.minVersion != null && (this.minInclusive ? this.minVersion.compareTo(exportPackage.minVersion) > 0 : this.minVersion.compareTo(exportPackage.minVersion) >= 0)) {
            return false;
        }
        return this.maxVersion == null || !(this.maxInclusive ? this.maxVersion.compareTo(exportPackage.minVersion) < 0 : this.maxVersion.compareTo(exportPackage.minVersion) <= 0);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.minVersion != null ? this.minVersion.hashCode() : 0);
        result = 31 * result + (this.maxVersion != null ? this.maxVersion.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("package: " + this.name);
        if (this.minVersion != null) {
            builder.append(" Min: ").append(this.minVersion);
        }
        if (this.maxVersion != null) {
            builder.append(" Max: ").append(this.maxVersion);
        }
        builder.append(" Required: ").append(this.required);
        return builder.toString();
    }
}

