/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution.manifest;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PackageVersion
implements Comparable {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    public static final PackageVersion emptyVersion = new PackageVersion(0, 0, 0);

    public PackageVersion(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public PackageVersion(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    public PackageVersion(String version) {
        int major;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid format: " + version);
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format: " + version);
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro");
        }
        int length = this.qualifier.length();
        for (int i = 0; i < length; ++i) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".indexOf(this.qualifier.charAt(i)) != -1) continue;
            throw new IllegalArgumentException("invalid qualifier");
        }
    }

    public static PackageVersion parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new PackageVersion(version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        String base = this.major + SEPARATOR + this.minor + SEPARATOR + this.micro;
        if (this.qualifier.length() == 0) {
            return base;
        }
        return base + SEPARATOR + this.qualifier;
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PackageVersion)) {
            return false;
        }
        PackageVersion other = (PackageVersion)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        PackageVersion other = (PackageVersion)object;
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }
}

