/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.invocation;

import java.io.Serializable;
import org.fabric3.spi.invocation.ConversationContext;
import org.fabric3.spi.invocation.F3Conversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallFrame
implements Serializable {
    public static final CallFrame STATELESS_FRAME = new CallFrame();
    private static final long serialVersionUID = -6108279393891496098L;
    private String callbackUri;
    private Serializable correlationId;
    private ConversationContext conversationContext;
    private F3Conversation conversation;

    public CallFrame() {
    }

    public CallFrame(Serializable correlationId) {
        this(null, correlationId, null, null);
    }

    public CallFrame(String callbackUri, Serializable correlationId, F3Conversation conversation, ConversationContext conversationContext) {
        this.callbackUri = callbackUri;
        this.correlationId = correlationId;
        this.conversation = conversation;
        this.conversationContext = conversationContext;
    }

    public String getCallbackUri() {
        return this.callbackUri;
    }

    public <T extends Serializable> T getCorrelationId(Class<T> type) {
        return (T)((Serializable)type.cast(this.correlationId));
    }

    public F3Conversation getConversation() {
        return this.conversation;
    }

    public ConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public CallFrame copy() {
        return new CallFrame(this.callbackUri, this.correlationId, this.conversation, this.conversationContext);
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("CallFrame [Callback URI: ").append(this.callbackUri).append(" Correlation ID: ").append(this.correlationId);
        if (this.conversation != null) {
            s.append(" Conversation ID:").append(this.conversation.getConversationID());
            switch (this.conversationContext) {
                case PROPAGATE: {
                    s.append(" Propagate conversation");
                    break;
                }
                case NEW: {
                    s.append(" New conversation");
                }
            }
        }
        return s.append("]").toString();
    }
}

