/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.invocation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.SecuritySubject;
import org.fabric3.spi.invocation.CallFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkContext
implements Serializable {
    private static final long serialVersionUID = 9108092492339191639L;
    private SecuritySubject subject;
    private List<CallFrame> callStack;
    private Map<String, Object> headers;

    public void setSubject(SecuritySubject subject) {
        this.subject = subject;
    }

    public SecuritySubject getSubject() {
        return this.subject;
    }

    public void addCallFrame(CallFrame frame) {
        if (this.callStack == null) {
            this.callStack = new ArrayList<CallFrame>();
        }
        this.callStack.add(frame);
    }

    public void addCallFrames(List<CallFrame> frames) {
        if (this.callStack == null) {
            this.callStack = frames;
            return;
        }
        this.callStack.addAll(frames);
    }

    public CallFrame popCallFrame() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.remove(this.callStack.size() - 1);
    }

    public CallFrame peekCallFrame() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.get(this.callStack.size() - 1);
    }

    public List<CallFrame> getCallFrameStack() {
        return this.callStack;
    }

    public <T> T getHeader(Class<T> type, String name) {
        if (this.headers == null) {
            return null;
        }
        return type.cast(this.headers.get(name));
    }

    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        if (this.headers == null) {
            return;
        }
        this.headers.remove(name);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void addHeaders(Map<String, Object> newheaders) {
        if (this.headers == null) {
            this.headers = newheaders;
            return;
        }
        this.headers.putAll(newheaders);
    }
}

