/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalReference
extends Bindable {
    private static final long serialVersionUID = 2308698868251298609L;
    private ReferenceDefinition definition;
    private List<URI> promotedUris;
    private boolean resolved;
    private Autowire autowire = Autowire.INHERITED;
    private LogicalReference leafReference;

    public LogicalReference(URI uri, ReferenceDefinition definition, LogicalComponent<?> parent) {
        super(uri, definition != null ? definition.getServiceContract() : null, parent);
        this.definition = definition;
        this.promotedUris = new ArrayList<URI>();
        this.leafReference = this;
        if (definition != null) {
            this.addIntents(definition.getIntents());
            this.addPolicySets(definition.getPolicySets());
        }
    }

    public ReferenceDefinition getDefinition() {
        return this.definition;
    }

    public List<LogicalWire> getWires() {
        return this.getComposite().getWires(this);
    }

    public List<URI> getPromotedUris() {
        return this.promotedUris;
    }

    public void addPromotedUri(URI uri) {
        this.promotedUris.add(uri);
    }

    public void setPromotedUri(int index, URI uri) {
        this.promotedUris.set(index, uri);
    }

    public Autowire getAutowire() {
        return this.autowire;
    }

    public void setAutowire(Autowire autowire) {
        this.autowire = autowire;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public ComponentReference getComponentReference() {
        return (ComponentReference)((LogicalComponent)this.getParent()).getDefinition().getReferences().get(this.getDefinition().getName());
    }

    public LogicalReference getLeafReference() {
        return this.leafReference;
    }

    public void setLeafReference(LogicalReference leafReference) {
        this.leafReference = leafReference;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalReference test = (LogicalReference)obj;
        return this.getUri().equals(test.getUri());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    private LogicalCompositeComponent getComposite() {
        LogicalComponent parent = (LogicalComponent)this.getParent();
        LogicalCompositeComponent composite = (LogicalCompositeComponent)parent.getParent();
        return composite != null ? composite : (LogicalCompositeComponent)parent;
    }
}

