/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.physical;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.util.ParamTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterTypeHelper {
    private ParameterTypeHelper() {
    }

    public static List<Class<?>> loadSourceInParameterTypes(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        ArrayList types = new ArrayList();
        for (String param : operation.getSourceParameterTypes()) {
            Class<?> clazz = ParameterTypeHelper.loadClass(param, loader);
            types.add(clazz);
        }
        return types;
    }

    public static List<Class<?>> loadTargetInParameterTypes(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        ArrayList types = new ArrayList();
        for (String param : operation.getTargetParameterTypes()) {
            Class<?> clazz = ParameterTypeHelper.loadClass(param, loader);
            types.add(clazz);
        }
        return types;
    }

    public static List<Class<?>> loadSourceFaultTypes(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        ArrayList types = new ArrayList();
        for (String param : operation.getSourceFaultTypes()) {
            Class<?> clazz = ParameterTypeHelper.loadClass(param, loader);
            types.add(clazz);
        }
        return types;
    }

    public static List<Class<?>> loadTargetFaultTypes(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        ArrayList types = new ArrayList();
        for (String param : operation.getTargetFaultTypes()) {
            Class<?> clazz = ParameterTypeHelper.loadClass(param, loader);
            types.add(clazz);
        }
        return types;
    }

    public static Class<?> loadSourceOutputType(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        return ParameterTypeHelper.loadClass(operation.getSourceReturnType(), loader);
    }

    public static Class<?> loadTargetOutputType(PhysicalOperationDefinition operation, ClassLoader loader) throws ClassNotFoundException {
        return ParameterTypeHelper.loadClass(operation.getTargetReturnType(), loader);
    }

    private static Class<?> loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = ParamTypes.PRIMITIVES_TYPES.get(name);
        if (clazz == null) {
            clazz = loader.loadClass(name);
        }
        return clazz;
    }
}

