/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.work;

import com.bea.core.workmanager.WorkManagerFactory;
import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.runtime.weblogic.work.WebLogicWorkSchedulerMonitor;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WebLogicExecutorService
implements ExecutorService {
    private WebLogicWorkSchedulerMonitor monitor;
    private WorkManager workManager;

    public WebLogicExecutorService(@Monitor WebLogicWorkSchedulerMonitor monitor) {
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.workManager = WorkManagerFactory.getDefault();
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.workManager.schedule((Work)new CommonJWorkWrapper(command));
        }
        catch (WorkException e) {
            this.monitor.scheduleError(e);
        }
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private class CommonJWorkWrapper
    implements Work {
        private Runnable work;

        private CommonJWorkWrapper(Runnable work) {
            this.work = work;
        }

        public void release() {
        }

        public boolean isDaemon() {
            return false;
        }

        public void run() {
            this.work.run();
        }
    }
}

