/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicyPhase;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.PolicyResultImpl;
import org.fabric3.policy.resolver.ImplementationPolicyResolver;
import org.fabric3.policy.resolver.InteractionPolicyResolver;
import org.fabric3.spi.contract.OperationNotFoundException;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.policy.EffectivePolicy;
import org.fabric3.spi.policy.PolicyMetadata;
import org.fabric3.spi.policy.PolicyResolutionException;
import org.fabric3.spi.policy.PolicyResolver;
import org.fabric3.spi.policy.PolicyResult;
import org.fabric3.util.closure.Closure;
import org.fabric3.util.closure.CollectionUtils;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyResolver
implements PolicyResolver {
    private static final QName IMPLEMENTATION_SYSTEM = new QName("urn:fabric3.org:implementation", "implementation.system");
    private static final QName IMPLEMENTATION_SINGLETON = new QName("urn:fabric3.org:implementation", "singleton");
    private static final PolicyResult EMPTY_RESULT = new NullPolicyResult();
    private static final Closure<PolicySet, Boolean> INTERCEPTION = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.INTERCEPTION;
        }
    };
    private static final Closure<PolicySet, Boolean> PROVIDED = new Closure<PolicySet, Boolean>(){

        public Boolean execute(PolicySet policySet) {
            return policySet.getPhase() == PolicyPhase.PROVIDED;
        }
    };
    private InteractionPolicyResolver interactionResolver;
    private ImplementationPolicyResolver implementationResolver;
    private OperationResolver operationResolver;

    public DefaultPolicyResolver(@Reference InteractionPolicyResolver interactionResolver, @Reference ImplementationPolicyResolver implementationResolver, @Reference OperationResolver operationResolver) {
        this.interactionResolver = interactionResolver;
        this.implementationResolver = implementationResolver;
        this.operationResolver = operationResolver;
    }

    public PolicyResult resolvePolicies(List<LogicalOperation> operations, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> source, LogicalComponent<?> target) throws PolicyResolutionException {
        if (this.noPolicy(source) && this.noPolicy(target)) {
            return EMPTY_RESULT;
        }
        PolicyResultImpl policyResult = new PolicyResultImpl();
        this.resolveEndpointPolicies(policyResult, sourceBinding, targetBinding);
        for (LogicalOperation operation : operations) {
            this.resolveOperationPolicies(operation, policyResult, sourceBinding, targetBinding, target);
        }
        return policyResult;
    }

    private void resolveEndpointPolicies(PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding) throws PolicyResolutionException {
        Set<Intent> sourceEndpointIntents = this.interactionResolver.resolveProvidedIntents(sourceBinding);
        policyResult.addSourceEndpointIntents(sourceEndpointIntents);
        Set<Intent> targetEndpointIntents = this.interactionResolver.resolveProvidedIntents(targetBinding);
        policyResult.addTargetEndpointIntents(targetEndpointIntents);
        Set<PolicySet> endpointPolicies = this.interactionResolver.resolvePolicySets(sourceBinding);
        policyResult.addSourceEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
        endpointPolicies = this.interactionResolver.resolvePolicySets(targetBinding);
        policyResult.addTargetEndpointPolicySets(CollectionUtils.filter(endpointPolicies, PROVIDED));
        policyResult.addInterceptedEndpointPolicySets(CollectionUtils.filter(endpointPolicies, INTERCEPTION));
    }

    private void resolveOperationPolicies(LogicalOperation operation, PolicyResultImpl policyResult, LogicalBinding<?> sourceBinding, LogicalBinding<?> targetBinding, LogicalComponent<?> target) throws PolicyResolutionException {
        Set<Intent> sourceOperationIntents = this.interactionResolver.resolveProvidedIntents(operation, sourceBinding);
        policyResult.addSourceIntents(operation, sourceOperationIntents);
        Set<Intent> targetOperationIntents = this.interactionResolver.resolveProvidedIntents(operation, targetBinding);
        policyResult.addTargetIntents(operation, targetOperationIntents);
        if (target != null) {
            Set<Intent> sourceImplementationIntents = this.implementationResolver.resolveProvidedIntents(target, operation);
            policyResult.addSourceIntents(operation, sourceImplementationIntents);
        }
        Set<PolicySet> policies = this.interactionResolver.resolvePolicySets(operation, sourceBinding);
        policyResult.addSourcePolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        policies = this.interactionResolver.resolvePolicySets(operation, targetBinding);
        policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
        policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        if (target != null) {
            Bindable parent = (Bindable)targetBinding.getParent();
            LogicalOperation targetOperation = this.matchOperation(operation, parent);
            policies = this.implementationResolver.resolvePolicySets(target, targetOperation);
            PolicyMetadata metadata = policyResult.getMetadata(operation);
            metadata.addAll(targetOperation.getDefinition().getMetadata());
            metadata.addAll(((LogicalComponent)((LogicalAttachPoint)targetOperation.getParent()).getParent()).getDefinition().getImplementation().getMetadata());
            policyResult.addTargetPolicySets(operation, CollectionUtils.filter(policies, PROVIDED));
            policyResult.addInterceptedPolicySets(operation, CollectionUtils.filter(policies, INTERCEPTION));
        }
    }

    private LogicalOperation matchOperation(LogicalOperation operation, Bindable bindable) throws PolicyResolutionException {
        String name = operation.getDefinition().getName();
        List operations = bindable instanceof LogicalReference ? bindable.getCallbackOperations() : bindable.getOperations();
        try {
            LogicalOperation matched = this.operationResolver.resolve(operation, operations);
            if (matched == null) {
                throw new AssertionError((Object)("No matching operation for " + name));
            }
            return matched;
        }
        catch (OperationNotFoundException e) {
            throw new PolicyResolutionException((Throwable)e);
        }
    }

    private boolean noPolicy(LogicalComponent<?> component) {
        return component != null && (component.getDefinition().getImplementation().isType(IMPLEMENTATION_SYSTEM) || component.getDefinition().getImplementation().isType(IMPLEMENTATION_SINGLETON));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullEffectivePolicy
    implements EffectivePolicy {
        private NullEffectivePolicy() {
        }

        public Set<Intent> getEndpointIntents() {
            return Collections.emptySet();
        }

        public Set<PolicySet> getEndpointPolicySets() {
            return Collections.emptySet();
        }

        public List<Intent> getIntents(LogicalOperation operation) {
            return Collections.emptyList();
        }

        public List<PolicySet> getPolicySets(LogicalOperation operation) {
            return Collections.emptyList();
        }

        public List<Intent> getOperationIntents() {
            return Collections.emptyList();
        }

        public Map<LogicalOperation, List<PolicySet>> getOperationPolicySets() {
            return Collections.emptyMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullPolicyResult
    implements PolicyResult {
        private PolicyMetadata metadata = new PolicyMetadata();

        private NullPolicyResult() {
        }

        public List<PolicySet> getInterceptedPolicySets(LogicalOperation operation) {
            return Collections.emptyList();
        }

        public EffectivePolicy getSourcePolicy() {
            return new NullEffectivePolicy();
        }

        public EffectivePolicy getTargetPolicy() {
            return new NullEffectivePolicy();
        }

        public Set<PolicySet> getInterceptedEndpointPolicySets() {
            return Collections.emptySet();
        }

        public PolicyMetadata getMetadata(LogicalOperation operation) {
            return this.metadata;
        }
    }
}

