/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.resolver;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.policy.PolicyRegistry;
import org.fabric3.spi.policy.PolicyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPolicyResolver {
    protected LogicalComponentManager lcm;
    protected PolicyEvaluator policyEvaluator;
    protected PolicyRegistry policyRegistry;

    protected AbstractPolicyResolver(PolicyRegistry policyRegistry, LogicalComponentManager lcm, PolicyEvaluator policyEvaluator) {
        this.policyRegistry = policyRegistry;
        this.lcm = lcm;
        this.policyEvaluator = policyEvaluator;
    }

    protected Set<PolicySet> resolvePolicies(Set<Intent> intents, LogicalScaArtifact<?> target) throws PolicyResolutionException {
        LinkedHashSet<PolicySet> policies = new LinkedHashSet<PolicySet>();
        Collection definitions = this.policyRegistry.getAllDefinitions(PolicySet.class);
        for (PolicySet policySet : definitions) {
            Iterator<Intent> iterator = intents.iterator();
            while (iterator.hasNext()) {
                Intent intent = iterator.next();
                if (!policySet.doesProvide(intent.getName())) continue;
                String appliesTo = policySet.getAppliesTo();
                String attachTo = policySet.getAttachTo();
                if ((appliesTo != null || attachTo != null) && (attachTo != null || !this.policyEvaluator.doesApply(appliesTo, target))) continue;
                policies.add(policySet);
                iterator.remove();
            }
        }
        return policies;
    }

    protected void filterInvalidIntents(QName type, Set<Intent> requiredIntents) throws PolicyResolutionException {
        Iterator<Intent> it = requiredIntents.iterator();
        while (it.hasNext()) {
            Intent intent = it.next();
            QName intentName = intent.getName();
            if (intent.getIntentType() != null) {
                if (intent.doesConstrain(type)) continue;
                it.remove();
                continue;
            }
            if (!intent.isQualified()) {
                throw new PolicyResolutionException("Unqualified intent without constrained artifact", (Object)intentName);
            }
            Intent qualifiableIntent = (Intent)this.policyRegistry.getDefinition(intent.getQualifiable(), Intent.class);
            if (qualifiableIntent == null) {
                throw new PolicyResolutionException("Unknown intent", (Object)intent.getQualifiable());
            }
            if (qualifiableIntent.doesConstrain(type)) continue;
            it.remove();
        }
    }

    protected Set<QName> aggregateIntents(LogicalScaArtifact<?> scaArtifact) {
        LinkedHashSet<QName> intentNames = new LinkedHashSet<QName>();
        for (LogicalScaArtifact temp = scaArtifact; temp != null; temp = temp.getParent()) {
            intentNames.addAll(temp.getIntents());
        }
        return intentNames;
    }

    protected Set<Intent> resolveProfileIntents(Set<QName> intentNames) throws PolicyResolutionException {
        LinkedHashSet<Intent> requiredIntents = new LinkedHashSet<Intent>();
        for (QName intentName : intentNames) {
            Intent intent = (Intent)this.policyRegistry.getDefinition(intentName, Intent.class);
            if (intent == null) {
                throw new PolicyResolutionException("Unknown intent", (Object)intentName);
            }
            if (intent.isProfile()) {
                for (QName requiredIntentName : intent.getRequires()) {
                    Intent requiredIntent = (Intent)this.policyRegistry.getDefinition(requiredIntentName, Intent.class);
                    if (requiredIntent == null) {
                        throw new PolicyResolutionException("Unknown intent", (Object)requiredIntentName);
                    }
                    requiredIntents.add(requiredIntent);
                }
                continue;
            }
            requiredIntents.add(intent);
        }
        return requiredIntents;
    }
}

