/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.definitions.ImplementationType;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.policy.resolver.AbstractPolicyResolver;
import org.fabric3.policy.resolver.ImplementationPolicyResolver;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.policy.PolicyRegistry;
import org.fabric3.spi.policy.PolicyResolutionException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationPolicyResolverImpl
extends AbstractPolicyResolver
implements ImplementationPolicyResolver {
    public ImplementationPolicyResolverImpl(@Reference PolicyRegistry policyRegistry, @Reference LogicalComponentManager lcm, @Reference PolicyEvaluator policyEvaluator) {
        super(policyRegistry, lcm, policyEvaluator);
    }

    @Override
    public Set<Intent> resolveProvidedIntents(LogicalComponent<?> component, LogicalOperation operation) throws PolicyResolutionException {
        Implementation implementation = component.getDefinition().getImplementation();
        QName type = implementation.getType();
        ImplementationType implementationType = (ImplementationType)this.policyRegistry.getDefinition(type, ImplementationType.class);
        if (implementationType == null) {
            return Collections.emptySet();
        }
        Set mayProvidedIntents = implementationType.getMayProvide();
        Set<Intent> requiredIntents = this.getRequestedIntents(component, operation);
        LinkedHashSet<Intent> intentsToBeProvided = new LinkedHashSet<Intent>();
        for (Intent intent : requiredIntents) {
            if (!mayProvidedIntents.contains(intent.getName())) continue;
            intentsToBeProvided.add(intent);
        }
        return intentsToBeProvided;
    }

    @Override
    public Set<PolicySet> resolvePolicySets(LogicalComponent<?> component, LogicalOperation operation) throws PolicyResolutionException {
        Implementation implementation = component.getDefinition().getImplementation();
        QName type = implementation.getType();
        ImplementationType implementationType = (ImplementationType)this.policyRegistry.getDefinition(type, ImplementationType.class);
        Set alwaysProvidedIntents = new LinkedHashSet();
        Set mayProvidedIntents = new LinkedHashSet();
        if (implementationType != null) {
            alwaysProvidedIntents = implementationType.getAlwaysProvide();
            mayProvidedIntents = implementationType.getMayProvide();
        }
        Set<Intent> requiredIntents = this.getRequestedIntents(component, operation);
        HashSet<Intent> requiredIntentsCopy = new HashSet<Intent>(requiredIntents);
        for (Intent intent : requiredIntentsCopy) {
            QName intentName = intent.getName();
            if (!alwaysProvidedIntents.contains(intentName) && !mayProvidedIntents.contains(intentName)) continue;
            requiredIntents.remove(intent);
        }
        Set<QName> policySets = this.aggregatePolicySets(operation, component);
        if (requiredIntents.isEmpty() && policySets.isEmpty()) {
            return Collections.emptySet();
        }
        Set<PolicySet> policies = this.resolvePolicies(requiredIntents, (LogicalScaArtifact<?>)component);
        if (!requiredIntents.isEmpty()) {
            throw new PolicyResolutionException("Unable to resolve all intents", requiredIntents);
        }
        for (QName name : policySets) {
            PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
            policies.add(policySet);
        }
        return policies;
    }

    private Set<Intent> getRequestedIntents(LogicalComponent<?> logicalComponent, LogicalOperation operation) throws PolicyResolutionException {
        LinkedHashSet<QName> intentNames = new LinkedHashSet<QName>();
        intentNames.addAll(operation.getIntents());
        intentNames.addAll(logicalComponent.getDefinition().getImplementation().getIntents());
        intentNames.addAll(this.aggregateIntents((LogicalScaArtifact<?>)logicalComponent));
        Set<Intent> requiredIntents = this.resolveProfileIntents(intentNames);
        this.filterInvalidIntents(Intent.IMPLEMENTATION, requiredIntents);
        return requiredIntents;
    }

    protected Set<QName> aggregatePolicySets(LogicalOperation operation, LogicalComponent<?> logicalComponent) {
        LinkedHashSet<QName> policySetNames = new LinkedHashSet<QName>();
        for (LogicalOperation temp = operation; temp != null; temp = temp.getParent()) {
            policySetNames.addAll(temp.getPolicySets());
        }
        policySetNames.addAll(logicalComponent.getPolicySets());
        return policySetNames;
    }
}

