/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.policy.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.model.type.definitions.BindingType;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.policy.infoset.PolicyEvaluator;
import org.fabric3.policy.resolver.AbstractPolicyResolver;
import org.fabric3.policy.resolver.InteractionPolicyResolver;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.policy.PolicyRegistry;
import org.fabric3.spi.policy.PolicyResolutionException;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionPolicyResolverImpl
extends AbstractPolicyResolver
implements InteractionPolicyResolver {
    public InteractionPolicyResolverImpl(@Reference PolicyRegistry policyRegistry, @Reference LogicalComponentManager lcm, @Reference PolicyEvaluator policyEvaluator) {
        super(policyRegistry, lcm, policyEvaluator);
    }

    @Override
    public Set<Intent> resolveProvidedIntents(LogicalOperation operation, LogicalBinding binding) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.getOperationIntents(operation);
        QName type = binding.getDefinition().getType();
        return this.filterProvidedIntents(type, requiredIntents);
    }

    @Override
    public Set<Intent> resolveProvidedIntents(LogicalBinding binding) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.aggregateBindingIntents(binding);
        QName type = binding.getDefinition().getType();
        return this.filterProvidedIntents(type, requiredIntents);
    }

    @Override
    public Set<PolicySet> resolvePolicySets(LogicalBinding binding) throws PolicyResolutionException {
        QName type = binding.getDefinition().getType();
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        Set alwaysProvidedIntents = new LinkedHashSet();
        Set mayProvidedIntents = new LinkedHashSet();
        if (bindingType != null) {
            alwaysProvidedIntents = bindingType.getAlwaysProvide();
            mayProvidedIntents = bindingType.getMayProvide();
        }
        Set<Intent> requiredIntents = this.aggregateBindingIntents(binding);
        HashSet<Intent> requiredIntentsCopy = new HashSet<Intent>(requiredIntents);
        for (Intent intent : requiredIntentsCopy) {
            QName intentName = intent.getName();
            if (!alwaysProvidedIntents.contains(intentName) && !mayProvidedIntents.contains(intentName)) continue;
            requiredIntents.remove(intent);
        }
        Set<PolicySet> policies = this.resolvePolicies(requiredIntents, (LogicalScaArtifact<?>)binding);
        if (!requiredIntents.isEmpty()) {
            throw new PolicyResolutionException("Unable to resolve all intents", requiredIntents);
        }
        Set<QName> policySets = this.aggregateBindingPolicySets(binding);
        for (QName name : policySets) {
            PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
            policies.add(policySet);
        }
        return policies;
    }

    @Override
    public Set<PolicySet> resolvePolicySets(LogicalOperation operation, LogicalBinding binding) throws PolicyResolutionException {
        QName type = binding.getDefinition().getType();
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        Set alwaysProvidedIntents = new LinkedHashSet();
        Set mayProvidedIntents = new LinkedHashSet();
        if (bindingType != null) {
            alwaysProvidedIntents = bindingType.getAlwaysProvide();
            mayProvidedIntents = bindingType.getMayProvide();
        }
        Set<Intent> requiredIntents = this.getOperationIntents(operation);
        HashSet<Intent> requiredIntentsCopy = new HashSet<Intent>(requiredIntents);
        for (Intent intent : requiredIntentsCopy) {
            QName intentName = intent.getName();
            if (!alwaysProvidedIntents.contains(intentName) && !mayProvidedIntents.contains(intentName)) continue;
            requiredIntents.remove(intent);
        }
        Set<QName> policySets = this.getOperationPolicySets(operation);
        if (requiredIntents.isEmpty() && policySets.isEmpty()) {
            return Collections.emptySet();
        }
        Set<PolicySet> policies = this.resolvePolicies(requiredIntents, (LogicalScaArtifact<?>)binding);
        if (!requiredIntents.isEmpty()) {
            throw new PolicyResolutionException("Unable to resolve all intents", requiredIntents);
        }
        for (QName name : policySets) {
            PolicySet policySet = (PolicySet)this.policyRegistry.getDefinition(name, PolicySet.class);
            policies.add(policySet);
        }
        return policies;
    }

    private Set<Intent> getOperationIntents(LogicalOperation operation) throws PolicyResolutionException {
        LinkedHashSet<QName> intentNames = new LinkedHashSet<QName>();
        intentNames.addAll(operation.getIntents());
        return this.expandAndFilterIntents(intentNames);
    }

    private Set<Intent> aggregateBindingIntents(LogicalBinding<?> logicalBinding) throws PolicyResolutionException {
        LinkedHashSet<QName> intentNames = new LinkedHashSet<QName>();
        intentNames.addAll(logicalBinding.getDefinition().getIntents());
        intentNames.addAll(this.aggregateIntents((LogicalScaArtifact<?>)logicalBinding));
        return this.expandAndFilterIntents(intentNames);
    }

    private Set<Intent> expandAndFilterIntents(Set<QName> intentNames) throws PolicyResolutionException {
        Set<Intent> requiredIntents = this.resolveProfileIntents(intentNames);
        this.filterInvalidIntents(Intent.BINDING, requiredIntents);
        return requiredIntents;
    }

    private Set<QName> getOperationPolicySets(LogicalOperation operation) {
        LinkedHashSet<QName> policySetNames = new LinkedHashSet<QName>();
        for (LogicalOperation temp = operation; temp != null; temp = temp.getParent()) {
            policySetNames.addAll(temp.getPolicySets());
        }
        return policySetNames;
    }

    private Set<QName> aggregateBindingPolicySets(LogicalBinding<?> binding) {
        LinkedHashSet<QName> policySetNames = new LinkedHashSet<QName>();
        for (LogicalScaArtifact temp = binding; temp != null; temp = temp.getParent()) {
            policySetNames.addAll(temp.getPolicySets());
        }
        return policySetNames;
    }

    private Set<Intent> filterProvidedIntents(QName type, Set<Intent> requiredIntents) {
        BindingType bindingType = (BindingType)this.policyRegistry.getDefinition(type, BindingType.class);
        if (bindingType == null) {
            return Collections.emptySet();
        }
        Set mayProvidedIntents = bindingType.getMayProvide();
        LinkedHashSet<Intent> intentsToBeProvided = new LinkedHashSet<Intent>();
        for (Intent intent : requiredIntents) {
            if (!mayProvidedIntents.contains(intent.getName())) continue;
            intentsToBeProvided.add(intent);
        }
        return intentsToBeProvided;
    }
}

