/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.tx.TxAction;
import org.fabric3.tx.TxMonitor;
import org.oasisopen.sca.ServiceRuntimeException;

public class TxInterceptor
implements Interceptor {
    private Interceptor next;
    private TransactionManager transactionManager;
    private TxAction txAction;
    private TxMonitor monitor;

    public TxInterceptor(TransactionManager transactionManager, TxAction txAction, TxMonitor monitor) {
        this.transactionManager = transactionManager;
        this.txAction = txAction;
        this.monitor = monitor;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public Message invoke(Message message) {
        Message ret;
        Transaction transaction = this.getTransaction();
        if (this.txAction == TxAction.BEGIN) {
            if (transaction == null) {
                this.begin();
            }
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.suspend();
        }
        try {
            ret = this.next.invoke(message);
        }
        catch (RuntimeException e) {
            if (this.txAction == TxAction.BEGIN && transaction == null) {
                this.rollback();
            } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
                this.setRollbackOnly();
            }
            throw e;
        }
        if (this.txAction == TxAction.BEGIN && transaction == null && !ret.isFault()) {
            this.commit();
        } else if (this.txAction == TxAction.BEGIN && transaction == null && ret.isFault()) {
            this.rollback();
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.resume(transaction);
        }
        return ret;
    }

    private void setRollbackOnly() throws ServiceRuntimeException {
        try {
            this.monitor.markedForRollback(Thread.currentThread().getName());
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private Transaction getTransaction() throws ServiceRuntimeException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void rollback() throws ServiceRuntimeException {
        try {
            this.monitor.rolledback(Thread.currentThread().getName());
            this.transactionManager.rollback();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void begin() throws ServiceRuntimeException {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void suspend() throws ServiceRuntimeException {
        try {
            this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void resume(Transaction transaction) throws ServiceRuntimeException {
        try {
            this.transactionManager.resume(transaction);
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (InvalidTransactionException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void commit() throws ServiceRuntimeException {
        try {
            if (this.transactionManager.getStatus() != 1) {
                this.transactionManager.commit();
            } else {
                this.rollback();
            }
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

